/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class ToggleExternalFlag
extends AbstractHandler
implements IElementUpdater {
    private static Resource getFlagResource(ISelection sel) {
        Resource r = (Resource)AdaptionUtils.adaptToSingle((Object)sel, Resource.class);
        return r;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Resource resource = ToggleExternalFlag.getFlagResource(sel);
        if (resource == null) {
            return null;
        }
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
                Boolean ext = g.hasStatement(resource, dr.ExternalFlag);
                if (ext.booleanValue()) {
                    g.deny(resource, dr.ExternalFlag);
                } else {
                    g.claim(resource, dr.ExternalFlag, resource);
                }
            }
        });
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        Session s;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.simantics.modeling.ui.toggleExternalFlag");
        State state = command.getState("org.simantics.modeling.ui.toggleExternalFlag.state");
        if (state == null) {
            state = new State();
            state.setValue((Object)Boolean.TRUE);
            command.addState("org.simantics.modeling.ui.toggleExternalFlag.state", state);
        }
        if ((s = Simantics.peekSession()) != null) {
            Resource resource;
            Boolean value = Boolean.TRUE;
            IWorkbenchSite site = (IWorkbenchSite)parameters.get("org.eclipse.ui.part.IWorkbenchPartSite");
            ISelectionProvider sp = site.getSelectionProvider();
            if (sp != null && (resource = ToggleExternalFlag.getFlagResource(sp.getSelection())) != null) {
                try {
                    value = (Boolean)s.syncRequest((Read)new Read<Boolean>(){

                        public Boolean perform(ReadGraph graph) throws DatabaseException {
                            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                            return graph.hasStatement(resource, dr.ExternalFlag);
                        }
                    });
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
            state.setValue((Object)value);
        }
        Boolean checked = (Boolean)state.getValue();
        element.setChecked(checked.booleanValue());
        element.setIcon((ImageDescriptor)(checked != false ? Activator.TICK_ICON : null));
    }
}

