/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.genericfileimport.wizard;

import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.genericfileimport.wizard.GenericFileImportPlan;
import org.simantics.utils.ui.ErrorLogger;

public class GenericFileImportPage
extends WizardPage {
    String failure;
    GenericFileImportPlan importModel;
    CCombo importLocation;

    protected GenericFileImportPage(GenericFileImportPlan model) {
        super("Import File", "Define Import Location", null);
        this.importModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("&File:");
        this.importLocation = new CCombo(container, 2048);
        this.importLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.importLocation);
        this.importLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericFileImportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Br&owse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GenericFileImportPage.this.getShell(), 4096);
                dialog.setText("Choose File to Import");
                String loc = GenericFileImportPage.this.importLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.*"});
                dialog.setFilterNames(new String[]{"All files"});
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                GenericFileImportPage.this.importLocation.setText(file);
                GenericFileImportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        for (String path : this.importModel.recentLocations) {
            this.importLocation.add(path);
        }
        if (this.importLocation.getItemCount() > 0) {
            this.importLocation.select(0);
        }
    }

    void validatePage() {
        if (this.failure != null) {
            this.setErrorMessage(this.failure);
            this.setPageComplete(false);
            return;
        }
        String importLoc = this.importLocation.getText();
        if (importLoc.isEmpty()) {
            this.setMessage("Select file to import.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(importLoc);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage("Selected file is invalid.");
            this.setPageComplete(false);
            return;
        }
        this.importModel.importLocation = file;
        this.setErrorMessage(null);
        this.setMessage("Ready to import " + file.getName());
        this.setPageComplete(true);
    }
}

