/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.elements.DecorationSVGNode;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.document.DocumentResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagram.style.DecorationStyles;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;

public class DocumentDecorationStyle
extends StyleBase<DocumentResult> {
    private static final String DECORATION_NODE_NAME = "documentDecorations";
    private static Point2D connectionOffset = new Point2D.Double(-2.0, 2.0);
    private static Function<Rectangle2D, AffineTransform> boundsToTransform = bounds -> AffineTransform.getTranslateInstance(bounds.getMinX() - 1.2, bounds.getMaxY() + 1.2);

    private List<Resource> getContexts(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>(3);
        result.add(element);
        Resource config = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (config != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.DiagramConnectionToConnection)) != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        return result;
    }

    public DocumentResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        for (Resource r : this.getContexts(graph, element)) {
            if (!graph.hasStatement(r, DOC.HasDocumentation)) continue;
            return new DocumentResult(DecorationStyles.getStyleIdentifier(graph, runtimeDiagram, element));
        }
        return null;
    }

    public void applyStyleForNode(EvaluationContext observer, INode node, DocumentResult result) {
        if (result == null) {
            ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
            return;
        }
        SVGNode svgNode = (SVGNode)ProfileVariables.claimChild((INode)node, (String)"", (String)DECORATION_NODE_NAME, DecorationSVGNode.class, (Observer)observer);
        svgNode.setZIndex(Integer.MAX_VALUE);
        svgNode.setTransform(DecorationStyles.getDecorationPosition(node, boundsToTransform, connectionOffset));
        svgNode.setData(Activator.DOCUMENT_SVG_TEXT);
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
    }

    public String toString() {
        return "Document decoration";
    }

    public record DocumentResult(Object identier) {
    }
}

