/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.diagram.adapter.RouteGraphUtils;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.elementclass.RouteGraphConnectionClass;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.map.Tuple;

public class ConnectionPointNameStyle
extends StyleBase<List<Result>> {
    protected static final String PARENT_NODE_NAME_PREFIX = "_tNames";
    protected static final String NODE_NAME_PREFIX = "_";
    protected static final Font FONT = Font.decode("Arial 6");
    protected static final double DEFAULT_SCALE = 0.05;
    private Color backgroundColor = Color.WHITE;
    private Color textColor = Color.BLACK;
    private double textScale;

    public ConnectionPointNameStyle() {
        this(0.05);
    }

    public ConnectionPointNameStyle(double textScale) {
        this.textScale = textScale;
    }

    public List<Result> calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        BasicResources BR = BasicResources.getInstance((ReadGraph)graph);
        Layer0 L0 = BR.L0;
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource comp = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (comp == null) {
            return Collections.emptyList();
        }
        String compName = (String)graph.getPossibleRelatedValue(comp, L0.HasName, (Binding)Bindings.STRING);
        if (compName == null) {
            return Collections.emptyList();
        }
        Resource elementType = graph.getPossibleType(element, BR.DIA.DefinedElement);
        if (elementType == null) {
            return Collections.emptyList();
        }
        AffineTransform parentTransform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        ArrayList<Result> result = new ArrayList<Result>();
        result.add(new Result(compName, parentTransform, null));
        Resource orderedSet = graph.getPossibleObject(elementType, BR.STR.IsDefinedBy);
        if (orderedSet != null) {
            for (Resource el : graph.syncRequest((AsyncMultiRead)new OrderedSet(orderedSet))) {
                String name;
                Resource cpRel;
                Resource gcp = graph.getPossibleObject(el, BR.DIA.HasConnectionPoint);
                if (gcp == null || (cpRel = graph.getPossibleObject(gcp, MOD.DiagramConnectionRelationToConnectionRelation)) == null || (name = (String)graph.getPossibleRelatedValue(cpRel, L0.HasName, (Binding)Bindings.STRING)) == null) continue;
                Integer allowedDirections = (Integer)graph.getPossibleRelatedValue(el, BR.DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER);
                result.add(new Result(name, DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)el), allowedDirections));
            }
        }
        return result;
    }

    protected static AffineTransform translateAndScaleIfNeeded(AffineTransform tr, double rotation, double offsetX, double offsetY, double scale) {
        if (rotation != 0.0 || offsetX != 0.0 || offsetY != 0.0 || scale != 1.0) {
            tr = new AffineTransform(tr);
            if (rotation != 0.0) {
                tr.rotate(rotation);
            }
            if (offsetX != 0.0 || offsetY != 0.0) {
                tr.translate(offsetX, offsetY);
            }
            if (scale != 1.0) {
                tr.scale(scale, scale);
            }
        }
        return tr;
    }

    protected AffineTransform getTerminalTransform(AffineTransform transform, double rotation, double offsetX, double offsetY, double scale) {
        return ConnectionPointNameStyle.translateAndScaleIfNeeded(transform, rotation, offsetX, offsetY, scale);
    }

    public void applyStyleForNode(EvaluationContext observer, INode _node, List<Result> resultList) {
        int count;
        this.cleanupStyleForNode(_node);
        int n = count = resultList != null ? resultList.size() : 0;
        if (count < 2) {
            return;
        }
        G2DParentNode parentNode = (G2DParentNode)ProfileVariables.claimChild((INode)_node, (String)"", (String)PARENT_NODE_NAME_PREFIX, G2DParentNode.class, (Observer)observer);
        parentNode.setTransform(resultList.get(0).getTransform());
        parentNode.setZIndex(0x3FFFFFFF);
        Rectangle2D eBounds = NodeUtil.getLocalElementBounds((INode)_node);
        int i = 1;
        while (i < count) {
            int directions;
            Result result = resultList.get(i);
            TextNode node = (TextNode)ProfileVariables.claimChild((INode)parentNode, (String)"", (String)(NODE_NAME_PREFIX + i), TextNode.class, (Observer)observer);
            node.setZIndex(i);
            node.setBackgroundColor(this.backgroundColor);
            node.setColor(this.textColor);
            node.setText(result.getString());
            node.setVerticalAlignment((byte)Alignment.CENTER.ordinal());
            node.setAutomaticTextFlipping(TextNode.TextFlipping.VerticalTextDownwards);
            Alignment hAlign = Alignment.LEADING;
            AffineTransform tr = result.getTransform();
            double trX = tr.getTranslateX();
            double trY = tr.getTranslateY();
            double dx = 0.0;
            double dy = 0.0;
            double r = 0.0;
            double ts = 0.6;
            Integer dir = result.getAllowedDirections();
            int n2 = directions = dir != null ? RouteGraphUtils.rotateDirection((int)dir, (AffineTransform)tr) : RouteGraphConnectionClass.shortestDirectionOutOfBounds((double)trX, (double)trY, (Rectangle2D)eBounds);
            if (trX == 0.0 && trY == 0.0) {
                hAlign = Alignment.CENTER;
            } else {
                boolean up = (directions & 8) != 0;
                boolean down = (directions & 2) != 0;
                boolean left = (directions & 4) != 0;
                boolean right = (directions & 1) != 0;
                double ldx = Math.abs(eBounds.getMinX() - trX);
                double rdx = Math.abs(eBounds.getMaxX() - trX);
                double tdy = Math.abs(eBounds.getMinY() - trY);
                double bdy = Math.abs(eBounds.getMaxY() - trY);
                if (left && ldx <= rdx && ldx <= tdy && ldx <= bdy) {
                    dx = -ts;
                    hAlign = Alignment.TRAILING;
                } else if (right && rdx <= ldx && rdx <= tdy && rdx <= bdy) {
                    dx = ts;
                    hAlign = Alignment.LEADING;
                } else if (up && tdy <= ldx && tdy <= rdx && tdy <= bdy) {
                    dx = -ts;
                    r = 1.5707963267948966;
                    hAlign = Alignment.TRAILING;
                } else if (down && bdy <= ldx && bdy <= rdx && bdy <= tdy) {
                    dx = ts;
                    r = 1.5707963267948966;
                    hAlign = Alignment.LEADING;
                }
            }
            node.setHorizontalAlignment((byte)hAlign.ordinal());
            node.setTransform(this.getTerminalTransform(tr, r, dx, dy, this.textScale));
            ++i;
        }
    }

    protected void cleanupStyleForNode(INode node) {
        if (node instanceof SingleElementNode) {
            ProfileVariables.denyChild((INode)node, (String)"", (String)PARENT_NODE_NAME_PREFIX);
        }
    }

    protected static class Result
    extends Tuple {
        public Result(String string, AffineTransform tr, Integer direction) {
            super(new Object[]{string, tr, direction});
        }

        public String getString() {
            return (String)this.getField(0);
        }

        public AffineTransform getTransform() {
            return (AffineTransform)this.getField(1);
        }

        public Integer getAllowedDirections() {
            return (Integer)this.getField(2);
        }
    }
}

