/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.StringUtils;

public class AvailableFormatFactory
extends ReadFactoryImpl<Resource, Map<String, Object>> {
    public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(DIA.RealizedFormatter, Instances.class);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(input));
        if (model == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, Resource> result = new TreeMap<String, Resource>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        for (Resource template : query.find(graph, model)) {
            String sortKey = (String)graph.getPossibleRelatedAdapter(template, DIA.RealizedFormatter_sortKey, String.class);
            result.put(StringUtils.safeString((String)sortKey), template);
        }
        Object[] keys = new String[result.size()];
        Object[] values = new Object[result.size()];
        int i = 0;
        for (Resource template : result.values()) {
            String label = (String)graph.getPossibleRelatedAdapter(template, L0.HasLabel, String.class);
            String format = (String)graph.getPossibleRelatedValue(template, DIA.RealizedFormatter_HasDefinition, (Binding)Bindings.STRING);
            keys[i] = label + " (" + format + ")";
            values[i] = template;
            ++i;
        }
        return ArrayMap.make((Object[])keys, (Object[])values);
    }
}

