/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.ValueImplied;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.request.PossibleActiveValuation;
import org.simantics.db.layer0.request.PossibleSessionValuation;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.CompositeHintSynchronizer;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementLoader;
import org.simantics.diagram.synchronization.graph.MonitorSynchronizer;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Relationship;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagram.SliderClass;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class SliderClassFactory
extends SyncElementFactory {
    private static final IHintSynchronizer HINT_SYNCHRONIZER = new CompositeHintSynchronizer(new IHintSynchronizer[]{MonitorSynchronizer.INSTANCE, TransformSynchronizer.INSTANCE});

    public static ElementClass createSliderClass(Resource elementClass) {
        return SliderClass.create(null, null, null, null, null, 1.0, 1.0, new ElementHandler[]{new StaticObjectAdapter((Object)elementClass)});
    }

    public static ElementClass createSliderClass(Resource elementClass, IElement parentElement, SliderClass.Range<Double> range, Double value, Object component, String suffix, double staticScaleX, double staticScaleY) {
        return SliderClass.create(parentElement, range, value, component, suffix, staticScaleX, staticScaleY, new ElementHandler[]{new StaticObjectAdapter((Object)elementClass)});
    }

    public void load(ReadGraph g, final ICanvasContext canvas, final IDiagram diagram, final Resource element, IElement e) throws DatabaseException {
        if (!g.hasStatement(element)) {
            return;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        ElementClass ec = e.getElementClass();
        e.setHint(ElementHints.KEY_OBJECT, (Object)element);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)HINT_SYNCHRONIZER);
        AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)g, (Resource)element);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        MetricsFormat tmpf = null;
        try {
            tmpf = G2DUtils.getMetricsFormat((ReadGraph)g, (Resource)g.getSingleObject(element, dr.HasFormat));
        }
        catch (NoSingleResultException noSingleResultException) {
            tmpf = MetricsFormatList.METRICS_GENERIC;
        }
        MetricsFormat format = tmpf;
        e.setHint(SliderClass.KEY_NUMBER_FORMAT, (Object)format);
        double[] bounds = DiagramGraphUtil.getPossibleRelatedDoubleArray((ReadGraph)g, (Resource)element, (Resource)g2d.HasBounds);
        if (bounds != null) {
            e.setHint(ElementHints.KEY_BOUNDS, (Object)new Rectangle2D.Double(bounds[0], bounds[1], bounds[2], bounds[3]));
        }
        String label = (String)g.getPossibleRelatedValue(element, l0.HasLabel);
        ElementUtils.setText((IElement)e, (String)label);
        try {
            Resource valuation;
            Resource componentToElement = ModelingResources.getInstance((ReadGraph)g).ComponentToElement;
            Resource sliderComponent = g.getPossibleObject(element, dr.HasSliderComponent);
            String sliderSuffix = (String)g.getPossibleRelatedValue(element, dr.HasSliderSuffix, (Binding)Bindings.STRING);
            Double min = (Double)g.getPossibleRelatedValue(element, dr.HasSliderMinValue, (Binding)Bindings.DOUBLE);
            Double max = (Double)g.getPossibleRelatedValue(element, dr.HasSliderMaxValue, (Binding)Bindings.DOUBLE);
            e.setHint(SliderClass.KEY_SLIDER_COMPONENT, (Object)sliderComponent);
            e.setHint(SliderClass.KEY_SLIDER_SUFFIX, (Object)sliderSuffix);
            e.setHint(SliderClass.KEY_SLIDER_RANGE, new SliderClass.Range<Double>(min, max));
            e.setHint(SliderClass.KEY_SLIDER_VALUE, (Object)new Double(0.0));
            final Resource parentDiagramElement = g.getPossibleObject(sliderComponent, componentToElement);
            if (parentDiagramElement != null && !this.loadRelationships(g, diagram, e, parentDiagramElement)) {
                e.setHint(DiagramModelHints.KEY_ELEMENT_LOADER, (Object)new ElementLoader(){

                    public void load(ReadGraph g, IDiagram diagram, IElement element) {
                        SliderClassFactory.this.loadRelationships(g, diagram, element, parentDiagramElement);
                    }
                });
            }
            if (sliderSuffix != null) {
                e.setHint(SliderClass.KEY_TOOLTIP_TEXT, (Object)sliderSuffix);
            }
            final Session session = g.getSession();
            String sessionId = (String)diagram.getHint(DiagramModelHints.KEY_SESSION_ID);
            Resource resource = valuation = sessionId != null ? (Resource)g.syncRequest((Read)new PossibleSessionValuation(sliderComponent, sessionId, sliderSuffix)) : (Resource)g.syncRequest((Read)new PossibleActiveValuation(sliderComponent, sliderSuffix));
            if (valuation == null) {
                return;
            }
            session.asyncRequest((Read)new ValueImplied(valuation), (Listener)new Listener<Object>(){

                public void execute(final Object result) {
                    final IElement el = ElementUtils.getByData((IDiagram)diagram, (Object)element);
                    if (el != null) {
                        ThreadUtils.asyncExec((IThreadWorkQueue)canvas.getThreadAccess(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                el.setHint(SliderClass.KEY_SLIDER_VALUE, result);
                                SliderClass.update(el);
                            }
                        });
                    }
                }

                public void exception(Throwable t) {
                }

                public boolean isDisposed() {
                    return canvas.isDisposed();
                }
            });
            final StringModifier modifier = (StringModifier)g.adapt(valuation, StringModifier.class);
            TextEditor ed = (TextEditor)ec.getAtMostOneItemOfClass(TextEditor.class);
            ed.setModifier(e, new TextEditor.Modifier(){

                public String getValue(IElement element) {
                    return MonitorClass.editText((IElement)element);
                }

                public String isValid(IElement element, String text) {
                    return null;
                }

                public void modify(IElement element, final String text) {
                    session.asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            modifier.modify(graph, (Object)text);
                        }
                    });
                }
            });
        }
        catch (ResourceNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    boolean loadRelationships(ReadGraph g, IDiagram diagram, IElement element, Resource parentElementResource) {
        RelationshipHandler rh = (RelationshipHandler)diagram.getDiagramClass().getAtMostOneItemOfClass(RelationshipHandler.class);
        if (rh == null) {
            return true;
        }
        DataElementMap map = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        IElement parentElement = map.getElement(diagram, (Object)parentElementResource);
        if (parentElement != null) {
            element.setHint(ElementHints.KEY_PARENT_ELEMENT, (Object)parentElement);
            rh.claim(diagram, (Object)element, Relationship.CHILD_OF, (Object)parentElement);
            return true;
        }
        return false;
    }

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)SliderClassFactory.createSliderClass(elementType));
    }
}

