/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.scl.ui.editor.SCLTextEditorNew;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class SCLModuleViewer {
    ResourceManager resourceManager;
    Resource componentType;
    SCLTextEditorNew code;
    Form form;
    FormToolkit tk;

    public SCLModuleViewer(Composite parent, Resource _componentType, String formTitle) {
        this.componentType = _componentType;
        this.tk = new FormToolkit(parent.getDisplay());
        this.form = this.tk.createForm(parent);
        this.tk.decorateFormHeading(this.form);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.form);
        this.form.setText(formTitle);
        this.form.setImage(this.resourceManager.createImage(Activator.COMPONENT_TYPE_ICON));
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(this.form.getBody());
        Section codeSection = this.tk.createSection(this.form.getBody(), 320);
        codeSection.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)codeSection);
        codeSection.setText(Messages.SCLModuleViewer_Code);
        Composite codeSectionBody = this.tk.createComposite((Composite)codeSection);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(codeSectionBody);
        codeSection.setClient((Control)codeSectionBody);
        Composite codeButtons = this.tk.createComposite(codeSectionBody);
        GridDataFactory.fillDefaults().applyTo((Control)codeButtons);
        GridLayoutFactory.fillDefaults().applyTo(codeButtons);
        Button applyChanges = this.tk.createButton(codeButtons, Messages.SCLModuleViewer_ApplyChanges, 8);
        this.code = new SCLTextEditorNew(codeSectionBody, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.code);
        GridDataFactory.fillDefaults().applyTo((Control)applyChanges);
        applyChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String text = SCLModuleViewer.this.code.getContent();
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        graph.claimLiteral((this).SCLModuleViewer.this.componentType, L0.SCLModule_definition, (Object)text, (Binding)Bindings.STRING);
                    }
                });
            }
        });
        Simantics.getSession().asyncRequest((Read)new ResourceRead<String>(this.componentType){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                return (String)graph.getPossibleRelatedValue(this.resource, L0.SCLModule_definition, (Binding)Bindings.STRING);
            }
        }, (Listener)new Listener<String>(){

            public void execute(final String text) {
                SWTUtils.asyncExec((Widget)SCLModuleViewer.this.code, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SCLModuleViewer.this.code.isDisposed()) {
                            return;
                        }
                        (this).SCLModuleViewer.this.code.setContent(text, null);
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return SCLModuleViewer.this.code.isDisposed();
            }
        });
        this.code.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SCLModuleViewer.this.tk.dispose();
            }
        });
    }

    protected Datatype getPossibleDatatype(ReadGraph graph, Resource literal) throws DatabaseException {
        Binding binding = Bindings.getBindingUnchecked(Datatype.class);
        for (Resource dataTypeResource : graph.getObjects(literal, Layer0.getInstance((ReadGraph)graph).HasDataType)) {
            Datatype dt = (Datatype)graph.getPossibleValue(dataTypeResource, binding);
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    public void setFocus() {
        if (this.code != null && !this.code.isDisposed()) {
            this.code.setFocus();
        }
    }
}

