/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerSection;
import org.simantics.modeling.utils.ComponentTypeViewerPropertyInfo;
import org.simantics.modeling.utils.HeadlessComponentTypePropertiesResultRequest;

public class ComponentTypePropertiesResultRequest
extends HeadlessComponentTypePropertiesResultRequest {
    private final Collection<ComponentTypeViewerSection> sections;

    public ComponentTypePropertiesResultRequest(Resource componentType, Collection<ComponentTypeViewerSection> sections) {
        super(componentType);
        this.sections = sections;
    }

    protected void readSectionSpecificData(ReadGraph graph, ComponentTypeViewerPropertyInfo info) throws DatabaseException {
        Object sectionSpecificData = null;
        double priority = Double.NEGATIVE_INFINITY;
        if (this.sections != null) {
            for (ComponentTypeViewerSection section : this.sections) {
                double sectionPriority;
                Object temp = section.getSectionSpecificData(graph, info);
                if (temp == null || !((sectionPriority = section.getDataPriority()) > priority)) continue;
                sectionSpecificData = temp;
                priority = sectionPriority;
            }
        }
        info.sectionSpecificData = sectionSpecificData;
    }
}

