/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.style;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.actions.style.AWTStyleDialog;
import org.simantics.modeling.ui.actions.style.Messages;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.ui.ErrorLogger;

public class EditStyle {
    private static final String SECTION_AWT_STYLE_DIALOG = "AWTStyleDialog";
    private static final String SETTING_DIALOG_HEIGHT = "h";
    private static final String SETTING_DIALOG_WIDTH = "w";
    private static final String SETTING_DIALOG_Y = "y";
    private static final String SETTING_DIALOG_X = "x";

    public static void openStyleDialog(final Resource[] resources) {
        if (resources.length == 0) {
            return;
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                boolean hasStyle = true;
                Color color = null;
                Font font = null;
                MetricsFormat format = null;
                boolean hasColor = true;
                boolean hasFont = true;
                boolean hasFormat = true;
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    if (!graph.isInstanceOf(r, dr.StyleProvider)) {
                        hasStyle = false;
                        break;
                    }
                    if (graph.isInstanceOf(r, dr.FontProvider)) {
                        Resource fontR;
                        if (font == null && (fontR = graph.getPossibleObject(r, g2d.HasFont)) != null) {
                            font = G2DUtils.getFont((ReadGraph)graph, (Resource)fontR);
                        }
                    } else {
                        hasFont = false;
                    }
                    if (graph.isInstanceOf(r, dr.ColorProvider)) {
                        Resource colorR;
                        if (color == null && (colorR = graph.getPossibleObject(r, g2d.HasColor)) != null) {
                            color = G2DUtils.getColor((ReadGraph)graph, (Resource)colorR);
                        }
                    } else {
                        hasColor = false;
                    }
                    if (graph.isInstanceOf(r, dr.FormatProvider)) {
                        Resource formatR;
                        if (format == null && (formatR = graph.getPossibleObject(r, dr.HasFormat)) != null) {
                            format = G2DUtils.getMetricsFormat((ReadGraph)graph, (Resource)formatR);
                        }
                    } else {
                        hasFormat = false;
                    }
                    ++n2;
                }
                if (!hasStyle) {
                    return;
                }
                if (!(hasFont || hasColor || hasFormat)) {
                    return;
                }
                final Font currentFont = font;
                final Color currentColor = color;
                final MetricsFormat currentFormat = format;
                final boolean useFont = hasFont;
                final boolean useColor = hasColor;
                final boolean useFormat = hasFormat;
                Job job = new Job(Messages.EditStyle_OpenStyleDialog){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.EditStyle_MonitorOpenDialog, -1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setThread(Thread.currentThread());
                                try {
                                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                                }
                                catch (ClassNotFoundException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                catch (InstantiationException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                catch (IllegalAccessException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                catch (UnsupportedLookAndFeelException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                AWTStyleDialog dialog = new AWTStyleDialog(useFont, useColor, useFormat);
                                if (useColor && currentColor != null) {
                                    dialog.setStartColor(currentColor);
                                }
                                if (useFont && currentFont != null) {
                                    dialog.setStartFont(currentFont);
                                }
                                if (useFormat && currentFormat != null) {
                                    dialog.setStartFormat(currentFormat);
                                }
                                IDialogSettings ds = Activator.getDefault().getDialogSettings();
                                IDialogSettings sd = ds.getSection(EditStyle.SECTION_AWT_STYLE_DIALOG);
                                boolean restoredSettings = false;
                                if (sd == null) {
                                    sd = ds.addNewSection(EditStyle.SECTION_AWT_STYLE_DIALOG);
                                } else {
                                    try {
                                        int x = sd.getInt(EditStyle.SETTING_DIALOG_X);
                                        int y = sd.getInt(EditStyle.SETTING_DIALOG_Y);
                                        int w = sd.getInt(EditStyle.SETTING_DIALOG_WIDTH);
                                        int h = sd.getInt(EditStyle.SETTING_DIALOG_HEIGHT);
                                        if (w > 0 && h > 0) {
                                            dialog.setLocation(x, y);
                                            dialog.setSize(w, h);
                                            restoredSettings = true;
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                if (!restoredSettings) {
                                    dialog.setLocationByPlatform(true);
                                    dialog.pack();
                                }
                                this.done(Status.OK_STATUS);
                                dialog.setVisible(true);
                                Point loc = dialog.getLocation();
                                Dimension dim = dialog.getSize();
                                sd.put(EditStyle.SETTING_DIALOG_X, loc.x);
                                sd.put(EditStyle.SETTING_DIALOG_Y, loc.y);
                                sd.put(EditStyle.SETTING_DIALOG_WIDTH, dim.width);
                                sd.put(EditStyle.SETTING_DIALOG_HEIGHT, dim.height);
                                if (!dialog.isCancelled()) {
                                    final Font font = dialog.getFont();
                                    final Color color = dialog.getColor();
                                    final MetricsFormat format = dialog.getFormat();
                                    Session session = Simantics.getSession();
                                    session.markUndoPoint();
                                    session.asyncRequest((Write)new WriteRequest(){

                                        public void perform(WriteGraph graph) throws DatabaseException {
                                            G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                                            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                                            Resource fontResource = null;
                                            if (useFont && font != null) {
                                                fontResource = G2DUtils.createFont((WriteGraph)graph, (Font)font);
                                            }
                                            Resource colorResource = null;
                                            if (useColor && color != null) {
                                                colorResource = G2DUtils.createColor((WriteGraph)graph, (Color)color);
                                            }
                                            Resource formatResource = null;
                                            if (useFormat) {
                                                formatResource = G2DUtils.createMetricsFormat((WriteGraph)graph, (MetricsFormat)format);
                                            }
                                            Resource[] resourceArray = resources;
                                            int n = resources.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                Resource r = resourceArray[n2];
                                                if (useFont && fontResource != null && graph.isInstanceOf(r, dr.FontProvider)) {
                                                    graph.deny(r, g2d.HasFont);
                                                    graph.claim(r, g2d.HasFont, fontResource);
                                                }
                                                if (useColor && colorResource != null && graph.isInstanceOf(r, dr.ColorProvider)) {
                                                    graph.deny(r, g2d.HasColor);
                                                    graph.claim(r, g2d.HasColor, colorResource);
                                                }
                                                if (useFormat && formatResource != null && graph.isInstanceOf(r, dr.FormatProvider)) {
                                                    graph.deny(r, dr.HasFormat);
                                                    graph.claim(r, dr.HasFormat, formatResource);
                                                }
                                                ++n2;
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        return Job.ASYNC_FINISH;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
    }
}

