/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.MigrateModel;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchComponentTypeContribution
extends ContributionItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchComponentTypeContribution.class);

    public void fill(final Menu menu, int index) {
        List groups;
        final Resource resource = ResourceAdaptionUtils.toSingleWorkbenchResource();
        if (resource == null) {
            return;
        }
        try {
            groups = (List)Simantics.getSession().syncRequest((Read)new ComponentSwitchGroupQuery(resource));
        }
        catch (DatabaseException e) {
            LOGGER.error("Retrieval of switch groups failed.", (Throwable)e);
            return;
        }
        if (!groups.isEmpty()) {
            SelectionAdapter switchAction = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final Resource newComponentType = (Resource)e.widget.getData();
                    Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Resource component = SwitchComponentTypeContribution.elementToComponent((ReadGraph)graph, resource);
                            MigrateModel.changeComponentType((WriteGraph)graph, (Resource)component, (Resource)newComponentType);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Resource composite = graph.getPossibleObject(component, L0.PartOf);
                            if (composite == null) {
                                return;
                            }
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
                            if (diagram == null) {
                                return;
                            }
                            SWTUtils.asyncExec((Widget)menu, () -> DiagramEditor.reinitializeDiagram(diagram));
                        }
                    });
                }
            };
            for (SwitchGroup group : groups) {
                MenuItem item = new MenuItem(menu, 64);
                item.setText(group.label);
                Menu subMenu = new Menu(menu);
                item.setMenu(subMenu);
                for (Alternative alternative : group.alternatives) {
                    MenuItem subItem = new MenuItem(subMenu, 8);
                    subItem.setText(alternative.label);
                    subItem.setData((Object)alternative.componentType);
                    if (alternative.isCurrent) {
                        subItem.setEnabled(false);
                        continue;
                    }
                    subItem.addSelectionListener((SelectionListener)switchAction);
                }
            }
        }
    }

    private static Resource elementToComponent(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (component != null) {
            return component;
        }
        return element;
    }

    private static class Alternative
    implements Comparable<Alternative> {
        final String label;
        final Resource componentType;
        final boolean isCurrent;

        public Alternative(String label, Resource componentType, boolean isCurrent) {
            this.label = label;
            this.componentType = componentType;
            this.isCurrent = isCurrent;
        }

        @Override
        public int compareTo(Alternative o) {
            return this.label.compareTo(o.label);
        }
    }

    private static class ComponentSwitchGroupQuery
    extends UnaryRead<Resource, List<SwitchGroup>> {
        public ComponentSwitchGroupQuery(Resource parameter) {
            super((Object)parameter);
        }

        public List<SwitchGroup> perform(ReadGraph graph) throws DatabaseException {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource component = SwitchComponentTypeContribution.elementToComponent(graph, (Resource)this.parameter);
            Resource componentType = graph.getPossibleType(component, STR.Component);
            if (componentType == null) {
                return Collections.emptyList();
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ArrayList<SwitchGroup> result = new ArrayList<SwitchGroup>();
            for (Resource myAlt : graph.getObjects(componentType, MOD.BelongsToComponentSwitchGroup)) {
                Resource group = graph.getSingleObject(myAlt, MOD.ComponentSwitchGroup_alternative_Inverse);
                String label = (String)graph.getPossibleRelatedValue(group, L0.HasLabel);
                if (label == null && (label = (String)graph.getPossibleRelatedValue(group, L0.HasName)) == null) {
                    label = Messages.SwitchComponentTypeContribution_AlternativeTypes;
                }
                SwitchGroup groupObj = new SwitchGroup(label);
                for (Resource alt : graph.getObjects(group, MOD.ComponentSwitchGroup_alternative)) {
                    Resource altComponentType = graph.getSingleObject(alt, MOD.ComponentSwitchAlternative_componentType);
                    String label2 = (String)graph.getPossibleRelatedValue(alt, L0.HasLabel);
                    if (label2 == null && (label2 = (String)graph.getPossibleRelatedValue(alt, L0.HasName)) == null && (label2 = (String)graph.getPossibleRelatedValue(altComponentType, L0.HasLabel)) == null) {
                        label2 = (String)graph.getRelatedValue(altComponentType, L0.HasName);
                    }
                    groupObj.alternatives.add(new Alternative(label2, altComponentType, altComponentType.equals(componentType)));
                }
                Collections.sort(groupObj.alternatives);
                result.add(groupObj);
            }
            Collections.sort(result);
            return result;
        }
    }

    private static class SwitchGroup
    implements Comparable<SwitchGroup> {
        final String label;
        final ArrayList<Alternative> alternatives = new ArrayList();

        public SwitchGroup(String label) {
            this.label = label;
        }

        @Override
        public int compareTo(SwitchGroup o) {
            return this.label.compareTo(o.label);
        }
    }
}

