/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.viewpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.selectionview.SelectionViewResources;

public class VariablePropertyRule
implements ChildRule {
    private final ArrayList<String> requiredProperties = new ArrayList();
    private final ArrayList<String> filteredProperties = new ArrayList();

    public VariablePropertyRule(ReadGraph graph, Resource rule) throws DatabaseException {
        String name;
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(rule, MOD.ModelingBrowseContext_VariablePropertyRule_RequireProperty)) {
            name = (String)graph.getValue(r, (Binding)Bindings.STRING);
            this.requiredProperties.add(name);
        }
        for (Resource r : graph.getObjects(rule, MOD.ModelingBrowseContext_VariablePropertyRule_FilterProperty)) {
            name = (String)graph.getValue(r, (Binding)Bindings.STRING);
            this.filteredProperties.add(name);
        }
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    private boolean validate(ReadGraph graph, Variable parent, Variable child) throws DatabaseException {
        Variables.Role role;
        Resource predicate = child.getPossiblePredicateResource(graph);
        if (predicate == null) {
            return true;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return !L0.HasName.equals(predicate) && !L0.HasLabel.equals(predicate) || (role = parent.getRole(graph)) != Variables.Role.PROPERTY;
    }

    public Collection<?> getChildren(ReadGraph graph, Object parent_) throws DatabaseException {
        Collection underOfs;
        Variable parent = (Variable)parent_;
        ArrayList<Variable> result = new ArrayList<Variable>();
        Collection properties = parent.getProperties(graph);
        ArrayList<Resource> propertiesPredicates = new ArrayList<Resource>();
        for (Variable property : properties) {
            Resource r = property.getPossiblePredicateResource(graph);
            if (r == null) continue;
            propertiesPredicates.add(r);
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        block1: for (Variable property : properties) {
            Boolean hidden;
            if (this.isUnder(graph, L0, SEL, property, propertiesPredicates) || (hidden = (Boolean)property.getPossiblePropertyValue(graph, SEL.hidden, (Binding)Bindings.BOOLEAN)) != null && hidden.booleanValue()) continue;
            for (String req : this.requiredProperties) {
                if (property.getPossibleProperty(graph, req) == null) continue block1;
            }
            for (String req : this.filteredProperties) {
                if (property.getName(graph).equals(req)) continue block1;
            }
            if (!this.validate(graph, parent, property)) continue;
            result.add(property);
        }
        Resource predicateResource = parent.getPossiblePredicateResource(graph);
        if (predicateResource != null && !(underOfs = graph.getObjects(predicateResource, SEL.UnderOf)).isEmpty()) {
            Collection siblings = parent.getParent(graph).getProperties(graph);
            for (Variable sibling : siblings) {
                Resource r = sibling.getPossiblePredicateResource(graph);
                if (r == null || !underOfs.contains(r)) continue;
                result.add(sibling);
            }
        }
        if (this.isUnderProperty(graph, parent)) {
            Collection children = parent.getChildren(graph);
            for (Variable child : children) {
                result.add(child);
            }
        }
        return result;
    }

    private boolean isUnderProperty(ReadGraph graph, Variable variable) throws DatabaseException {
        Variables.Role role = variable.getRole(graph);
        if (Variables.Role.PROPERTY.equals((Object)role)) {
            return true;
        }
        Variable parent = variable.getParent(graph);
        if (parent == null) {
            return false;
        }
        return this.isUnderProperty(graph, parent);
    }

    private boolean isUnder(ReadGraph graph, Layer0 L0, SelectionViewResources SEL, Variable property, ArrayList<Resource> propertiesPredicates) throws DatabaseException {
        Resource predicate = property.getPossiblePredicateResource(graph);
        if (predicate == null) {
            return false;
        }
        Collection shownUnders = graph.getObjects(predicate, SEL.IsShownUnder);
        return !Collections.disjoint(propertiesPredicates, shownUnders);
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        Variable parent = ((Variable)child).getParent(graph);
        if (parent == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(parent);
    }
}

