/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property.svg;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLPrettyPrinter {
    private static DOMImplementationRegistry registry;

    static {
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    XMLPrettyPrinter() {
    }

    public static Document parseDocument(String document) throws IOException, SAXException, ParserConfigurationException {
        InputSource xmlSource = new InputSource(new StringReader(document));
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setExpandEntityReferences(false);
        dbFactory.setValidating(false);
        dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(xmlSource);
    }

    public static String prettyPrint(String document) throws IOException, SAXException, ParserConfigurationException {
        Document doc = XMLPrettyPrinter.parseDocument(document);
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput lsOutput = impl.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        serializer.setNewLine("\n");
        serializer.write(doc, lsOutput);
        String formatted = stringWriter.toString();
        return formatted;
    }

    public static String safePrettyPrint(String document) {
        try {
            return XMLPrettyPrinter.prettyPrint(document);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

