/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorPart;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.ui.SimanticsUI;

public class TypicalPropertyTester
extends PropertyTester {
    private static final String IS_TYPICAL_MASTER_EDITOR = "isMasterEditor";
    private static final String IS_TYPICAL_INSTANCE_EDITOR = "isInstanceEditor";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IEditorPart)) {
            return false;
        }
        if (IS_TYPICAL_MASTER_EDITOR.equals(property)) {
            return TypicalPropertyTester.isTypicalMasterEditor((IAdaptable)((IEditorPart)receiver));
        }
        if (IS_TYPICAL_INSTANCE_EDITOR.equals(property)) {
            return TypicalPropertyTester.isTypicalInstanceEditor((IAdaptable)((IEditorPart)receiver));
        }
        return false;
    }

    private static IDiagram getDiagram(IAdaptable editor) {
        DiagramViewer viewer = (DiagramViewer)editor.getAdapter(DiagramViewer.class);
        return viewer != null ? viewer.getAdapter(IDiagram.class) : null;
    }

    private static Set<String> getDiagramMappedCompositeTypes(IDiagram diagram) {
        Set<String> result = diagram != null ? (Set<String>)diagram.getHint(DiagramModelHints.KEY_MAPPED_COMPOSITE_RESOURCE_TYPE_URIS) : null;
        return result != null ? result : Collections.emptySet();
    }

    private static Set<String> getDiagramMappedCompositeTypes(IAdaptable editor) {
        return TypicalPropertyTester.getDiagramMappedCompositeTypes(TypicalPropertyTester.getDiagram(editor));
    }

    public static boolean isTypicalMasterEditor(IAdaptable editor) {
        Set<String> types = TypicalPropertyTester.getDiagramMappedCompositeTypes(editor);
        return types.contains("http://www.simantics.org/Modeling-1.2/MasterTypicalCompositeType");
    }

    private static boolean hasDiagramSource(IDiagram diagram) {
        return diagram.getHint(DiagramModelHints.KEY_HAS_DIAGRAM_SOURCE) != null;
    }

    public static boolean isTypicalInstanceEditor(IAdaptable editor) {
        IDiagram diagram = TypicalPropertyTester.getDiagram(editor);
        if (diagram == null) {
            return false;
        }
        Set<String> types = TypicalPropertyTester.getDiagramMappedCompositeTypes(diagram);
        return !types.contains("http://www.simantics.org/Modeling-1.2/MasterTypicalCompositeType") && types.contains("http://www.simantics.org/Modeling-1.2/TypicalComposite") && TypicalPropertyTester.hasDiagramSource(diagram);
    }

    private static boolean timeoutingRead(RequestProcessor processor, Read<Boolean> read) throws DatabaseException, InterruptedException {
        return (Boolean)RequestUtil.trySyncRequest((Session)Simantics.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, read);
    }

    public static boolean isTypicalMasterEditor(RequestProcessor processor, final Resource editorInputResource) throws DatabaseException, InterruptedException {
        return TypicalPropertyTester.timeoutingRead(processor, (Read<Boolean>)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return TypicalPropertyTester.isTypicalMasterEditor(graph, editorInputResource);
            }
        });
    }

    public static boolean isTypicalInstanceEditor(RequestProcessor processor, final Resource editorInputResource) throws DatabaseException, InterruptedException {
        return TypicalPropertyTester.timeoutingRead(processor, (Read<Boolean>)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return TypicalPropertyTester.isTypicalInstanceEditor(graph, editorInputResource);
            }
        });
    }

    public static boolean isTypicalMasterEditor(ReadGraph graph, Resource editorInputResource) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(editorInputResource, MOD.DiagramToComposite);
        return composite != null && graph.isInstanceOf(composite, MOD.MasterTypicalCompositeType);
    }

    public static boolean isTypicalInstanceEditor(ReadGraph graph, Resource editorInputResource) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        return graph.isInstanceOf(editorInputResource, DIA.Diagram) && graph.hasStatement(editorInputResource, MOD.HasDiagramSource);
    }
}

