/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.modeling.ui.preferences.DiagramPreferenceUtil;
import org.simantics.modeling.ui.preferences.DiagramPreferences;
import org.simantics.ui.workbench.preferences.NumberFieldEditor;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public DiagramPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
    }

    protected void createFieldEditors() {
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText("Grid Snapping");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group);
        NumberFieldEditor gridSizeField = new NumberFieldEditor("grid.size", "Grid size (mm)", (Composite)group);
        gridSizeField.setValidRange(0.001, 1000.0);
        this.addField((FieldEditor)gridSizeField);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)group);
        PageDescFieldEditor pageDescField = new PageDescFieldEditor(this.getFieldEditorParent());
        this.addField(pageDescField);
        Group displayGroup = new Group(this.getFieldEditorParent(), 0);
        displayGroup.setText("Display");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)displayGroup);
        BooleanFieldEditor displayPage = new BooleanFieldEditor("page.display.size", "Show page borders", 1, (Composite)displayGroup);
        this.addField((FieldEditor)displayPage);
        BooleanFieldEditor displayMargins = new BooleanFieldEditor("page.display.margins", "Show margins", 1, (Composite)displayGroup);
        this.addField((FieldEditor)displayMargins);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)displayGroup);
        Group disposingGroup = new Group(this.getFieldEditorParent(), 0);
        disposingGroup.setText("Disposing Policy");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)disposingGroup);
        IntegerFieldEditor maxOpenDiagrams = new IntegerFieldEditor("diagram.maxOpen", "Maximum number of hidden diagrams kept alive", (Composite)disposingGroup);
        maxOpenDiagrams.setValidateStrategy(0);
        maxOpenDiagrams.setValidRange(0, 20);
        maxOpenDiagrams.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)maxOpenDiagrams);
        BooleanFieldEditor disposeDiagramsOverTime = new BooleanFieldEditor("diagram.disposeOverTime", "Release hidden diagram resources after specified time", (Composite)disposingGroup);
        disposeDiagramsOverTime.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)disposeDiagramsOverTime);
        IntegerFieldEditor diagramDisposeWaitTime = new IntegerFieldEditor("diagram.disposeWaitTime", "Minimum time to release hidden operation diagram resources (s)", (Composite)disposingGroup);
        diagramDisposeWaitTime.setValidateStrategy(0);
        diagramDisposeWaitTime.setValidRange(1, 86400);
        diagramDisposeWaitTime.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)diagramDisposeWaitTime);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)disposingGroup);
    }

    static class PageDescFieldEditor
    extends FieldEditor {
        PageDesc desc;
        PageDesc previousDesc;
        Group group;
        Button portrait;
        Button landscape;
        Combo combo;
        Text topMargin;
        Text leftMargin;
        Text rightMargin;
        Text bottomMargin;
        Canvas pageCanvas;
        Listener marginListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 24) {
                    Text txt = (Text)event.widget;
                    String s = txt.getText();
                    double value = 0.0;
                    boolean invalid = false;
                    try {
                        value = DecimalFormat.getInstance().parse(s).doubleValue();
                    }
                    catch (ParseException parseException) {
                        invalid = true;
                    }
                    if (invalid) {
                        txt.setBackground(txt.getDisplay().getSystemColor(3));
                    } else {
                        txt.setBackground(null);
                        int mask = txt == topMargin ? 1 : (txt == leftMargin ? 4 : (txt == rightMargin ? 8 : (txt == bottomMargin ? 2 : 0)));
                        MarginUtils.Margin m = new MarginUtils.Margin(0.0, 0.0, value);
                        desc = desc.withMargins(desc.getMargins().withSide(mask, m));
                        this.applyValuesToWidgets(false);
                    }
                } else if (event.type == 15) {
                    Text txt = (Text)event.widget;
                    txt.selectAll();
                }
            }
        };
        int[] marginEvents = new int[]{24, 15};

        private void addMarginListeners() {
            int[] nArray = this.marginEvents;
            int n = this.marginEvents.length;
            int n2 = 0;
            while (n2 < n) {
                int et = nArray[n2];
                this.topMargin.addListener(et, this.marginListener);
                this.leftMargin.addListener(et, this.marginListener);
                this.rightMargin.addListener(et, this.marginListener);
                this.bottomMargin.addListener(et, this.marginListener);
                ++n2;
            }
        }

        private void removeMarginListeners() {
            int[] nArray = this.marginEvents;
            int n = this.marginEvents.length;
            int n2 = 0;
            while (n2 < n) {
                int et = nArray[n2];
                this.topMargin.removeListener(et, this.marginListener);
                this.leftMargin.removeListener(et, this.marginListener);
                this.rightMargin.removeListener(et, this.marginListener);
                this.bottomMargin.removeListener(et, this.marginListener);
                ++n2;
            }
        }

        public PageDescFieldEditor(Composite parent) {
            DiagramPreferences prefs = DiagramPreferenceUtil.getPreferences();
            this.previousDesc = this.desc = (PageDesc)prefs.get("page.default.size");
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            if (this.group != null) {
                ((GridData)this.group.getLayoutData()).horizontalSpan = numColumns;
            }
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.group = this.getGroupControl(parent);
            GridDataFactory.fillDefaults().grab(true, false).span(numColumns, 1).applyTo((Control)this.group);
        }

        protected Group getGroupControl(Composite parent) {
            if (this.group == null) {
                this.group = new Group(parent, 0);
                this.group.setText("Page Defaults");
                this.group.setToolTipText("The default settings for diagram pages.");
                this.group.setFont(parent.getFont());
                this.group.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        group = null;
                    }
                });
                GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)this.group);
                this.createChoosers((Composite)this.group);
            } else {
                this.checkParent((Control)this.group, parent);
            }
            return this.group;
        }

        protected void createChoosers(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText("Size:");
            this.combo = new Combo(parent, 0);
            this.combo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PageDesc pd = (PageDesc)combo.getData(combo.getItem(combo.getSelectionIndex()));
                    if (pd != null) {
                        desc = desc.withSizeFrom(pd).withText(pd.getText());
                        this.applyValuesToWidgets();
                    }
                }
            });
            Composite marginComposite = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).grab(true, true).align(0x1000000, 0x1000000).span(1, 2).applyTo((Control)marginComposite);
            GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).spacing(3, 3).applyTo(marginComposite);
            label = new Label(marginComposite, 0);
            label.setText("Margins (mm)");
            GridDataFactory.fillDefaults().align(0x1000000, 128).span(3, 1).applyTo((Control)label);
            label = new Label(marginComposite, 0);
            GridDataFactory.fillDefaults().align(0x1000000, 128).span(3, 1).applyTo((Control)label);
            new Label(marginComposite, 0);
            this.topMargin = new Text(marginComposite, 0x1000800);
            GridDataFactory.fillDefaults().hint(50, -1).grab(true, false).applyTo((Control)this.topMargin);
            new Label(marginComposite, 0);
            this.leftMargin = new Text(marginComposite, 133120);
            GridDataFactory.swtDefaults().hint(50, -1).grab(true, false).applyTo((Control)this.leftMargin);
            this.pageCanvas = new Canvas(marginComposite, 0);
            GridDataFactory.swtDefaults().hint(-1, -1).grab(true, true).applyTo((Control)this.pageCanvas);
            this.pageCanvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Point size = pageCanvas.getSize();
                    double w = desc.getOrientedWidth();
                    double h = desc.getOrientedHeight();
                    MarginUtils.Margins margins = desc.getMargins();
                    int top = (int)Math.round((double)size.y * margins.top.diagramAbsolute / h);
                    int bottom = (int)Math.round((double)size.y * margins.bottom.diagramAbsolute / h);
                    int left = (int)Math.round((double)size.x * margins.left.diagramAbsolute / w);
                    int right = (int)Math.round((double)size.x * margins.right.diagramAbsolute / w);
                    gc.setBackground(gc.getDevice().getSystemColor(15));
                    gc.fillRectangle(0, 0, size.x, size.y);
                    if (top + bottom < size.y && left + right < size.x) {
                        gc.drawLine(left, 0, left, size.y - 1);
                        gc.drawLine(size.x - 1 - right, 0, size.x - 1 - right, size.y - 1);
                        gc.drawLine(0, top, size.x - 1, top);
                        gc.drawLine(0, size.y - 1 - bottom, size.x - 1, size.y - 1 - bottom);
                        gc.setBackground(gc.getDevice().getSystemColor(1));
                        gc.fillRectangle(left + 1, top + 1, size.x - 2 - right - left, size.y - 2 - top - bottom);
                    }
                }
            });
            this.rightMargin = new Text(marginComposite, 18432);
            GridDataFactory.swtDefaults().hint(50, -1).grab(true, false).applyTo((Control)this.rightMargin);
            new Label(marginComposite, 0);
            this.bottomMargin = new Text(marginComposite, 0x1000800);
            GridDataFactory.fillDefaults().hint(50, -1).grab(true, false).applyTo((Control)this.bottomMargin);
            new Label(marginComposite, 0);
            this.addMarginListeners();
            label = new Label(parent, 0);
            label.setText("Orientation:");
            Composite comp = new Composite(parent, 0);
            GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)comp);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(comp);
            this.portrait = new Button(comp, 16);
            this.landscape = new Button(comp, 16);
            this.portrait.setText("Portrait");
            this.landscape.setText("Landscape");
            Listener orientationListener = new Listener(){

                public void handleEvent(Event event) {
                    desc = portrait.getSelection() ? desc.withOrientation(PageOrientation.Portrait) : desc.withOrientation(PageOrientation.Landscape);
                    this.applyValuesToWidgets();
                }
            };
            this.portrait.addListener(13, orientationListener);
            this.landscape.addListener(13, orientationListener);
            PageDesc[] pds = PageDesc.getPredefinedDescriptions();
            int i = 0;
            while (i < pds.length) {
                PageDesc pd = pds[i];
                this.combo.add(pd.getText());
                this.combo.setData(pd.getText(), (Object)pd);
                ++i;
            }
            this.applyValuesToWidgets();
        }

        protected void doLoad() {
            if (this.group != null) {
                DiagramPreferences prefs = DiagramPreferenceUtil.getPreferences();
                this.previousDesc = this.desc = (PageDesc)prefs.get("page.default.size");
                this.applyValuesToWidgets();
            }
        }

        private void applyValuesToWidgets() {
            this.applyValuesToWidgets(true);
        }

        private void applyValuesToWidgets(boolean applyMargins) {
            PageOrientation orit = this.desc.getOrientation();
            this.portrait.setSelection(orit == PageOrientation.Portrait);
            this.landscape.setSelection(orit == PageOrientation.Landscape);
            String name = this.desc.getText();
            int selectedIndex = this.combo.getSelectionIndex();
            int i = 0;
            while (i < this.combo.getItemCount()) {
                String item = this.combo.getItem(i);
                if (name.equals(item)) {
                    if (selectedIndex == i) break;
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
            if (applyMargins) {
                boolean marginEnabled = !this.desc.isInfinite();
                this.topMargin.setEnabled(marginEnabled);
                this.leftMargin.setEnabled(marginEnabled);
                this.rightMargin.setEnabled(marginEnabled);
                this.bottomMargin.setEnabled(marginEnabled);
                if (marginEnabled) {
                    this.removeMarginListeners();
                    MarginUtils.Margins margins = this.desc.getMargins();
                    this.topMargin.setText(DecimalFormat.getNumberInstance().format(margins.top.diagramAbsolute));
                    this.leftMargin.setText(DecimalFormat.getNumberInstance().format(margins.left.diagramAbsolute));
                    this.rightMargin.setText(DecimalFormat.getNumberInstance().format(margins.right.diagramAbsolute));
                    this.bottomMargin.setText(DecimalFormat.getNumberInstance().format(margins.bottom.diagramAbsolute));
                    this.addMarginListeners();
                }
            }
            this.layout(this.desc);
        }

        void layout(PageDesc desc) {
            double max = Math.max(desc.getOrientedWidth(), desc.getOrientedHeight());
            double min = Math.min(desc.getOrientedWidth(), desc.getOrientedHeight());
            double ratio = min / max;
            int larger = 100;
            int smaller = (int)Math.round(ratio * (double)larger);
            boolean vertical = desc.getOrientedWidth() < desc.getOrientedHeight();
            GridData gd = (GridData)this.pageCanvas.getLayoutData();
            gd.widthHint = vertical ? smaller : larger;
            gd.heightHint = vertical ? larger : smaller;
            this.group.getParent().layout(true, true);
            this.pageCanvas.redraw();
        }

        protected void doLoadDefault() {
            if (this.group != null) {
                DiagramPreferences prefs = DiagramPreferenceUtil.getDefaultPreferences();
                this.previousDesc = this.desc = (PageDesc)prefs.get("page.default.size");
                this.applyValuesToWidgets();
            }
            this.setPresentsDefaultValue(false);
        }

        protected void doStore() {
            try {
                DiagramPreferenceUtil.flushPreferences(DiagramPreferenceUtil.getPreferences().withValue("page.default.size", this.desc));
            }
            catch (BackingStoreException e) {
                ErrorLogger.defaultLogError((String)"Could not store diagram preferences", (Throwable)e);
            }
        }

        public int getNumberOfControls() {
            return 1;
        }
    }
}

