/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.common.node.IRefreshable;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.modelBrowser.model.IDisposable;
import org.simantics.modeling.ui.modelBrowser.model.INode2;
import org.simantics.modeling.ui.modelBrowser.model.IPathNode;
import org.simantics.modeling.ui.modelBrowser.model.Node;
import org.simantics.modeling.ui.modelBrowser.model.ReportFactory;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.ErrorLogger;

@Deprecated
public class Experiment
extends Node
implements INode2,
IPathNode,
IRefreshable,
IModifiable,
IDisposable {
    private static final String PENDING = "pending...";
    private static final Supplier<Boolean> DEFAULT_IS_DISPOSED = () -> false;
    Supplier<Boolean> isDisposed = DEFAULT_IS_DISPOSED;
    ResourceArray model;
    Session session;
    String name = "pending...";
    Collection<Object> children = Collections.emptyList();
    Runnable nameUpdater;
    Runnable childrenUpdater;

    public Experiment(ReadGraph graph, Resource experiment) {
        super(experiment);
        this.session = graph.getSession();
    }

    @Override
    public int getCategory(Runnable updater, NodeContext context) {
        return 0;
    }

    @Override
    public Collection<?> getChildren(final Runnable updater, NodeContext context) {
        this.childrenUpdater = updater;
        if (this.children != Collections.emptyList()) {
            return this.children;
        }
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ArrayList<Object> result = new ArrayList<Object>();
                try {
                    for (Statement factory : Experiment.this.findReportFactories(graph)) {
                        result.add(new ReportFactory(graph, factory));
                    }
                    Experiment.this.children = result;
                }
                catch (DatabaseException databaseException) {
                    Experiment.this.children = result;
                }
                updater.run();
            }
        });
        return this.children;
    }

    @Override
    public ImageDescriptor getImage(Runnable updater, NodeContext context) {
        return Activator.EXPERIMENT_ICON;
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        Object name = LabelerUtil.safeStringRepresentation((ReadGraph)graph, (Resource)this.resource);
        Resource initialState = graph.getPossibleObject(this.resource, SimulationResource.getInstance((ReadGraph)graph).HasInitialState);
        if (initialState != null) {
            name = (String)name + " (" + LabelerUtil.safeStringRepresentation((ReadGraph)graph, (Resource)initialState) + ")";
        }
        return name;
    }

    Read<String> labelRequest(Resource resource) {
        return new ResourceRead<String>(resource){

            public String perform(ReadGraph graph) throws DatabaseException {
                return Experiment.this.getLabel(graph);
            }
        };
    }

    @Override
    public String getLabel(Runnable updater, NodeContext context) {
        this.nameUpdater = updater;
        if (this.name != PENDING) {
            return this.name;
        }
        this.session.asyncRequest(this.labelRequest(this.resource), (Listener)new NameListener(this.nameUpdater, this.resource));
        return this.name;
    }

    @Override
    public Labeler.Modifier getModifier(String columnId) {
        return new LabelModifier(this.session, this.resource){

            public void accept(DatabaseException ex) {
                if (ex == null) {
                    Experiment.this.refreshName();
                } else {
                    super.accept(ex);
                }
            }
        };
    }

    @Override
    public boolean hasChildren(Runnable updater, NodeContext context) {
        return this.getChildren(updater, context).size() > 0;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public void refresh() {
        this.refreshName();
        this.refreshChildren();
    }

    public void refreshName() {
        this.name = PENDING;
        if (this.nameUpdater != null) {
            this.nameUpdater.run();
        }
    }

    public void refreshChildren() {
        this.children = Collections.emptyList();
        if (this.childrenUpdater != null) {
            this.childrenUpdater.run();
        }
    }

    Collection<Statement> findReportFactories(ReadGraph g) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)g);
        return g.getStatements(this.resource, DOC.HasReportFactory);
    }

    @Override
    public void handleDelete() throws DeleteException {
    }

    @Override
    public void setPath(ResourceArray path) {
        this.model = path;
    }

    @Override
    public ResourceArray getPath() {
        return this.model;
    }

    public Resource getModel() {
        return this.model.size() == 0 ? null : this.model.resources[0];
    }

    @Override
    public void setDisposedCallable(Supplier<Boolean> isDisposed) {
        this.isDisposed = isDisposed;
    }

    private class NameListener
    implements Listener<String> {
        private final Object identity;
        private final Resource resource;

        public NameListener(Object identity, Resource resource) {
            assert (identity != null);
            assert (resource != null);
            this.identity = identity;
            this.resource = resource;
        }

        public int hashCode() {
            return this.identity.hashCode() + 31 * this.resource.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameListener other = (NameListener)obj;
            return this.identity.equals(other.identity) && this.resource.equals(other.resource);
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }

        public boolean isDisposed() {
            return Experiment.this.isDisposed.get();
        }

        public void execute(String result) {
            Experiment.this.name = result;
            Experiment.this.nameUpdater.run();
        }
    }
}

