/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.modelBrowser.BaseViewpointFactory;
import org.simantics.modeling.ui.modelBrowser.BaseViewpointFactoryWithTester;
import org.simantics.modeling.ui.modelBrowser.model.IDisposable;
import org.simantics.modeling.ui.modelBrowser.model.INode;
import org.simantics.utils.datastructures.UnaryFunction;

class ResourceViewpointFactoryWithTester
extends BaseViewpointFactoryWithTester {
    ResourceViewpointFactoryWithTester(UnaryFunction<Boolean, Object> tester) {
        super(tester);
    }

    public String toString() {
        return "Consists Of";
    }

    public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key) {
        return new VP(updater, context, key);
    }

    class VP
    extends BaseViewpointFactory.VPB {
        public VP(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key) {
            super(updater, context, key);
        }

        public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            return this.toContextsWithInput(this.getChildren(graph, (Resource)this.context.getConstant(BuiltinKeys.INPUT)));
        }

        protected Collection<?> getChildren(ReadGraph g, Resource r) throws DatabaseException {
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            Collection resources = g.getObjects(r, b.ConsistsOf);
            ArrayList<Object> ret = new ArrayList<Object>(resources.size());
            for (Resource res : resources) {
                Object node = null;
                node = g.getPossibleAdapter(res, INode.class);
                if (node == null || !((Boolean)ResourceViewpointFactoryWithTester.this.tester.call(node)).booleanValue()) continue;
                if (node instanceof IDisposable) {
                    ((IDisposable)node).setDisposedCallable(this);
                }
                ret.add(node);
            }
            return ret;
        }
    }
}

