/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.modeling.ui.diagramEditor.tools.AlignTools;
import org.simantics.modeling.ui.diagramEditor.tools.DiagramTools;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class DiagramToolViewPart
extends ViewPart {
    private Composite parent;
    private final List<DiagramTools> tools = new ArrayList<DiagramTools>();
    private final Map<DiagramTools, Composite> toolComposites = new HashMap<DiagramTools, Composite>();
    private ISelectionListener listener;
    protected LocalResourceManager resourceManager;
    protected FormToolkit formToolkit;
    protected ScrolledForm mainForm;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.setLayout((Layout)new FillLayout());
        this.listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!(part instanceof DiagramEditor)) {
                    return;
                }
                for (DiagramTools t : DiagramToolViewPart.this.tools) {
                    t.setSelection(selection);
                }
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.listener);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)parent);
        this.formToolkit = new FormToolkit(parent.getDisplay());
        this.formToolkit.adapt(parent);
        this.mainForm = this.formToolkit.createScrolledForm(parent);
        this.mainForm.getBody().setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).margins(0, 5).spacing(1, 1).create());
        this.formToolkit.decorateFormHeading(this.mainForm.getForm());
        this.mainForm.setText("Tools");
        this.openTool(new AlignTools());
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void openTool(DiagramTools tool) {
        for (DiagramTools t : this.tools) {
            if (!t.getClass().equals(tool.getClass())) continue;
            return;
        }
        Section group = this.formToolkit.createSection(this.mainForm.getBody(), 258);
        group.setText(tool.getName());
        GridData data = new GridData(4, 128, true, false);
        group.setLayoutData((Object)data);
        Composite composite = this.formToolkit.createComposite((Composite)group);
        tool.createContols(composite, this.formToolkit, this.resourceManager);
        group.setClient((Control)composite);
        ToolBar toolBar = new ToolBar((Composite)group, 0x880000);
        group.setTextClient((Control)toolBar);
        group.setExpanded(true);
        this.tools.add(tool);
        this.toolComposites.put(tool, (Composite)group);
        this.parent.layout(true, true);
        tool.setSelection(this.getSite().getPage().getSelection());
    }

    private void closeTool(DiagramTools tool) {
        tool.dispose();
        this.tools.remove(tool);
        this.toolComposites.remove(tool).dispose();
    }

    public void dispose() {
        ArrayList<DiagramTools> tls = new ArrayList<DiagramTools>();
        tls.addAll(this.tools);
        for (DiagramTools t : tls) {
            this.closeTool(t);
        }
        this.getSite().getPage().removePostSelectionListener(this.listener);
        this.listener = null;
        this.formToolkit.dispose();
        super.dispose();
    }

    public static void open(DiagramTools tool) throws PartInitException {
        DiagramToolViewPart wp = (DiagramToolViewPart)WorkbenchUtils.showView((String)"org.simantics.modeling.ui.diagramtool");
        wp.openTool(tool);
    }
}

