/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisposingPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisposingPolicy.class);
    public static final int MAX_QUEUE_LENGTH = 8;
    public static final long DISPOSE_TIME = 30000L;
    public static final long MIN_DELAY = 200L;
    private volatile int maxQueueLength;
    private volatile boolean disposeOverTime;
    private volatile long disposeWaitTimeMs;
    private ArrayDeque<Runnable> disposerQueue;
    private TObjectLongHashMap<Runnable> disposeTime;
    private Runnable currentlyScheduled = null;
    private Runnable disposeOne = () -> {
        int queueLength = this.disposerQueue.size();
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug("disposeOne: queueLength: {}, maxQueueLength: {}", (Object)queueLength, (Object)this.maxQueueLength);
        }
        if (!this.disposeOverTime && queueLength <= this.maxQueueLength) {
            return;
        }
        if (queueLength > 0) {
            Runnable runnable = this.disposerQueue.removeFirst();
            this.disposeTime.remove((Object)runnable);
            this.currentlyScheduled = null;
            if (debug) {
                LOGGER.debug("Executing disposer {}", (Object)runnable);
            }
            runnable.run();
            if (debug) {
                LOGGER.debug("Executed disposer {}", (Object)runnable);
            }
            if (!this.disposerQueue.isEmpty()) {
                this.scheduleDispose();
            }
        }
    };

    public DisposingPolicy() {
        this(8, true, 30000L);
    }

    public DisposingPolicy(int maxQueueLength) {
        this(maxQueueLength, true, 30000L);
    }

    public DisposingPolicy(int maxQueueLength, boolean disposeOverTime, long disposeWaitTimeMs) {
        this.maxQueueLength = maxQueueLength;
        this.disposeOverTime = disposeOverTime;
        this.disposeWaitTimeMs = disposeWaitTimeMs;
        this.disposerQueue = new ArrayDeque(maxQueueLength);
        this.disposeTime = new TObjectLongHashMap(maxQueueLength);
    }

    public void reconfigure(int maxQueueLength, boolean disposeOverTime, int disposeWaitTimeMs) {
        this.maxQueueLength = maxQueueLength;
        this.disposeOverTime = disposeOverTime;
        this.disposeWaitTimeMs = disposeWaitTimeMs;
        this.scheduleDispose();
    }

    public void setMaxQueueLength(int maxQueueLength) {
        this.maxQueueLength = maxQueueLength;
    }

    public void setDisposalTimes(boolean disposeOverTime, long disposeWaitTimeMs) {
        this.disposeOverTime = disposeOverTime;
        this.disposeWaitTimeMs = disposeWaitTimeMs;
        this.scheduleDispose();
    }

    private void scheduleDispose() {
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug("scheduleDispose({}, {}, {})", new Object[]{this.disposeOverTime, this.disposerQueue.size(), this.maxQueueLength});
        }
        if (!this.disposeOverTime && this.disposerQueue.size() <= this.maxQueueLength) {
            return;
        }
        this.currentlyScheduled = this.disposerQueue.peekFirst();
        if (this.currentlyScheduled == null) {
            return;
        }
        long delay = Math.max(this.disposeTime.get((Object)this.currentlyScheduled) - System.currentTimeMillis(), 200L);
        Display.getCurrent().timerExec((int)delay, this.disposeOne);
        if (debug) {
            LOGGER.debug("Scheduled disposer {} in {} ms", (Object)this.currentlyScheduled, (Object)delay);
        }
    }

    public void addDisposer(Runnable disposer) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added disposer {}", (Object)disposer);
        }
        if (this.disposeTime.contains((Object)disposer)) {
            return;
        }
        long t = System.currentTimeMillis();
        this.disposerQueue.addLast(disposer);
        this.disposeTime.put((Object)disposer, t + this.disposeWaitTimeMs);
        int disposeCount = this.disposerQueue.size() - this.maxQueueLength;
        if (disposeCount > 0) {
            Iterator<Runnable> it = this.disposerQueue.iterator();
            int i = 0;
            while (i < disposeCount && it.hasNext()) {
                this.disposeTime.put((Object)it.next(), t);
                ++i;
            }
        }
        this.scheduleDispose();
    }

    public void removeDisposer(Runnable disposer) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removed disposer {}", (Object)disposer);
        }
        this.disposerQueue.remove(disposer);
        this.disposeTime.remove((Object)disposer);
        if (disposer == this.currentlyScheduled) {
            this.currentlyScheduled = null;
            if (!this.disposerQueue.isEmpty()) {
                this.scheduleDispose();
            }
        }
    }
}

