/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagram.style.SymbolNameResult;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;

public class SymbolTerminalNameStyle
extends StyleBase<SymbolNameResult> {
    static final Font FONT = Font.decode("Arial 6");
    private static final String NODE_NAME = "terminalName";

    public SymbolNameResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        return this.calculateStyle(graph, runtimeDiagram, entry, groupItem, null);
    }

    public SymbolNameResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        AffineTransform transform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource binds = DiagramGraphUtil.getPossibleConnectionPointOfTerminal((ReadGraph)graph, (Resource)element);
        if (binds == null) {
            return null;
        }
        Resource conn = graph.getPossibleObject(binds, MOD.DiagramConnectionRelationToConnectionRelation);
        String name = (String)graph.getPossibleRelatedValue(conn, L0.HasName, (Binding)Bindings.STRING);
        if (conn == null || name == null) {
            return null;
        }
        return new SymbolNameResult(name, transform);
    }

    private AffineTransform translateAndScaleIfNeeded(AffineTransform tr, Vec2d offset, double scale) {
        if (!offset.isZero() || scale != 1.0) {
            tr = new AffineTransform(tr);
            tr.translate(offset.x, offset.y);
            tr.scale(scale, scale);
        }
        return tr;
    }

    private AffineTransform getSymbolTransform(INode node, Vec2d offset, double size) {
        if (node instanceof SingleElementNode) {
            SingleElementNode s = (SingleElementNode)node;
            INode symbol = NodeUtil.findChildByPrefix((G2DParentNode)s, (String)"composite_image");
            return this.translateAndScaleIfNeeded(symbol != null ? ((IG2DNode)symbol).getTransform() : new AffineTransform(), offset, size);
        }
        return null;
    }

    public void applyStyleForNode(EvaluationContext observer, INode _node, SymbolNameResult result) {
        if (result == null) {
            ProfileVariables.denyChild((INode)_node, (String)"", (String)NODE_NAME);
            return;
        }
        TextNode node = (TextNode)ProfileVariables.claimChild((INode)_node, (String)"", (String)NODE_NAME, TextNode.class, (Observer)observer);
        node.setZIndex(Integer.MAX_VALUE);
        node.setTransform(this.getSymbolTransform(_node, new Vec2d(0.0, -1.0), 0.08));
        node.setText(result.getName());
        node.setHorizontalAlignment((byte)Alignment.CENTER.ordinal());
        node.setBackgroundColor(Color.WHITE);
        node.setPadding(0.2, 0.0);
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)NODE_NAME);
    }
}

