/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.utils.strings.StringUtils;

public class MonitorWriter
implements ElementWriter {
    public static final Object LABEL = new Object();

    public void addToGraph(WriteGraph g, IElement element, Resource elementResource) throws DatabaseException {
        Resource template;
        Resource model;
        Resource monitorComponent = (Resource)element.getHint(MonitorClass.KEY_MONITOR_COMPONENT);
        if (monitorComponent == null) {
            throw new IllegalArgumentException("KEY_MONITOR_COMPONENT hint not set");
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        if (!g.hasStatement(elementResource, L0X.ObtainsProperty) && (model = (Resource)g.syncRequest((Read)new PossibleIndexRoot(elementResource))) != null && (template = g.getPossibleObject(model, DIA.HasDefaultMonitorTemplate)) != null) {
            g.claim(elementResource, L0X.ObtainsProperty1, null, template);
        }
        String label = "";
        g.claimLiteral(elementResource, L0.HasLabel, (Object)label);
        Double ddir = (Double)element.getHint(MonitorClass.KEY_DIRECTION);
        if (ddir != null) {
            DiagramGraphUtil.setRelatedValue((WriteGraph)g, (Resource)elementResource, (Resource)DIA.HasDirection, (Resource)L0.Double, (Object)ddir, (Binding)Bindings.DOUBLE);
        }
        if (g.isInstanceOf(monitorComponent, DIA.Element)) {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
            Resource component = g.getPossibleObject(monitorComponent, MOD.ElementToComponent);
            if (component != null) {
                monitorComponent = component;
            }
        }
        g.claim(elementResource, DIA.HasMonitorComponent, monitorComponent);
        String monitorSuffix = StringUtils.safeString((String)((String)element.getHint(MonitorClass.KEY_MONITOR_SUFFIX)));
        g.claimLiteral(elementResource, DIA.HasMonitorSuffix, (Object)monitorSuffix, (Binding)Bindings.STRING);
        Double borderWidth = (Double)element.getHint(MonitorClass.KEY_BORDER_WIDTH);
        Alignment hAlign = (Alignment)element.getHint(ElementHints.KEY_HORIZONTAL_ALIGN);
        Alignment vAlign = (Alignment)element.getHint(ElementHints.KEY_VERTICAL_ALIGN);
        if (borderWidth != null) {
            g.claimLiteral(elementResource, G2D.HasStrokeWidth, (Object)borderWidth, (Binding)Bindings.DOUBLE);
        }
        if (hAlign != null) {
            g.claim(elementResource, G2D.HasHorizontalAlignment, this.toResource((ReadGraph)g, hAlign, G2D));
        }
        if (vAlign != null) {
            g.claim(elementResource, G2D.HasVerticalAlignment, this.toResource((ReadGraph)g, vAlign, G2D));
        }
    }

    Resource toResource(ReadGraph g, Alignment alignment, G2DResource g2d) {
        switch (alignment) {
            case LEADING: {
                return g2d.Alignment_Leading;
            }
            case TRAILING: {
                return g2d.Alignment_Trailing;
            }
            case CENTER: {
                return g2d.Alignment_Center;
            }
        }
        throw new IllegalArgumentException("unsupported alignment: " + String.valueOf(alignment));
    }

    public void removeFromGraph(WriteGraph graph, Resource elementResource) throws DatabaseException {
    }
}

