/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.chart.property;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.ui.chart.property.TimeInputValidator;

public class TimePropertyModifier
extends TextModifyListenerImpl<Resource> {
    private final String propertyURI;
    TimeInputValidator validator;

    public TimePropertyModifier(ISessionContext context, String propertyURI, TimeInputValidator validator) {
        this.propertyURI = propertyURI;
        this.validator = validator;
    }

    public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
        Double x = this.validator.parse(text);
        if (x == null) {
            if (graph.hasStatement(input, graph.getResource(this.propertyURI))) {
                graph.denyValue(input, graph.getResource(this.propertyURI));
            }
        } else {
            graph.claimLiteral(input, graph.getResource(this.propertyURI), (Object)x, (Binding)Bindings.DOUBLE);
        }
    }
}

