/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.validation.ValidateMapping;
import org.simantics.structural.stubs.StructuralResource2;

public class ValidateMappingHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            final HashSet<Resource> compositesToTest = new HashSet<Resource>();
            List elements = ((StructuredSelection)selection).toList();
            for (Object element : elements) {
                Resource node;
                if (!(element instanceof IAdaptable) || (node = (Resource)((IAdaptable)element).getAdapter(Resource.class)) == null) continue;
                compositesToTest.add(node);
            }
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    ArrayDeque<Resource> toBeChecked = new ArrayDeque<Resource>(compositesToTest);
                    while (!toBeChecked.isEmpty()) {
                        Resource check = (Resource)toBeChecked.poll();
                        for (Resource child : (Collection)graph.syncRequest((Read)new ObjectsWithType(check, L0.ConsistsOf, STR.Composite))) {
                            if (!compositesToTest.add(child)) continue;
                            toBeChecked.offer(child);
                        }
                    }
                    for (Resource composite : compositesToTest) {
                        graph.syncRequest((Read)new ValidateMapping(composite));
                    }
                }
            });
        }
        return null;
    }
}

