package org.simantics.modeling.ui.typicals;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.simantics.modeling.typicals.TypicalPreferences;
import org.simantics.utils.ui.ErrorLogger;


/**
 * @author Tuukka Lehtonen
 *
 */
public class ToggleTypicalRealtimeSync extends AbstractHandler implements IElementUpdater {

	@Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Preferences prefs = InstanceScope.INSTANCE.getNode(TypicalPreferences.P_NODE);
        boolean value = prefs.getBoolean(TypicalPreferences.P_REALTIME_TYPICAL_SYNC_ENABLED, TypicalPreferences.DEFAULT_REALTIME_TYPICAL_SYNC_ENABLED);
        value = !value;
        prefs.putBoolean(TypicalPreferences.P_REALTIME_TYPICAL_SYNC_ENABLED, value);
        try {
            prefs.flush();
        } catch (BackingStoreException e) {
            ErrorLogger.defaultLogError(e);
        }

        return null;
    }

    @Override
    public void updateElement(UIElement element, @SuppressWarnings("rawtypes") Map parameters) {
        Preferences prefs = InstanceScope.INSTANCE.getNode(TypicalPreferences.P_NODE);
        boolean value = prefs.getBoolean(TypicalPreferences.P_REALTIME_TYPICAL_SYNC_ENABLED, TypicalPreferences.DEFAULT_REALTIME_TYPICAL_SYNC_ENABLED);
        element.setChecked( value );
    }

}
