package org.simantics.modeling.ui.typicals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.ui.documents.OpenPlainTextDocumentAdapter;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class SyncActiveModelTypicals extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell(event);
        Session session = Simantics.getSession();
        try {
            Resource[] activeModelTypicalTemplates = session.syncRequest(new Read<Resource[]>() {
                @Override
                public Resource[] perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance(graph);
                    ModelingResources MOD = ModelingResources.getInstance(graph);
                    SimulationResource SIMU = SimulationResource.getInstance(graph);

                    Collection<Resource> activeModels = graph.syncRequest(new ObjectsWithType(Simantics.getProjectResource(), L0X.Activates, SIMU.Model));
                    Instances query = graph.adapt(MOD.MasterTypicalCompositeType, Instances.class);

                    Set<Resource> result = new HashSet<Resource>();
                    for (Resource activeModel : activeModels) {
                        Collection<Resource> typicalComposites = query.find(graph, activeModel);
                        for (Resource typicalComposite : typicalComposites) {
                            for (Resource typicalDiagram : graph.getObjects(typicalComposite, MOD.CompositeToDiagram)) {
                                result.add(typicalDiagram);
                            }
                        }
                    }
                    return result.toArray(Resource.NONE);
                }
            });

            if (activeModelTypicalTemplates.length > 0) {
//                StringBuilder msg = new StringBuilder("Are you sure you want to synchronize ")
//                .append(activeModelTypicalTemplates.length)
//                .append(" typical template");
//                if (activeModelTypicalTemplates.length > 1)
//                    msg.append("s to all their instances?");
//                else
//                    msg.append(" to all its instances?");
//                if (!MessageDialog.openConfirm(shell, "Synchronize All Typical Templates with Instances", msg.toString()))
//                    return null;

                StringBuilder msg = new StringBuilder("Synchronizing ")
                .append(activeModelTypicalTemplates.length)
                .append(" typical template");
                if (activeModelTypicalTemplates.length > 1)
                    msg.append("s to all their instances.");
                else
                    msg.append(" to all its instances.");

                RuleChooserDialog.RuleResult result = RuleChooserDialog.choose(shell, msg.toString(), activeModelTypicalTemplates);
                if(result == null) return null;

                session.markUndoPoint();
                SyncTypicalTemplatesToInstances req = new SyncTypicalTemplatesToInstances(result.selectedRules, activeModelTypicalTemplates).logging(result.logging); 
                session.syncRequest(req);
                if (result.logging) {
                    for(Resource log : req.logs)
                        new OpenPlainTextDocumentAdapter().openEditor(log);
                }

            } else {
                MessageDialog.openInformation(shell, "No Typical Templates", "The currently active model doesn't contain any typical diagram templates.");
            }
        } catch (Exception e) {
            ErrorLogger.defaultLogError(e);
        }
        return null;
    }

}
