/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class WriteSCLScriptDefinition extends WriteRequest {

    private final String scriptURI;
    private final String definition;

    public WriteSCLScriptDefinition(String scriptURI, String sourceText) {
        this.scriptURI = scriptURI;
        this.definition = sourceText;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        Resource moduleResource = graph.getPossibleResource(scriptURI);
        if (moduleResource == null)
            return;
        Layer0 L0 = Layer0.getInstance(graph);
        if (!graph.isInstanceOf(moduleResource, L0.SCLScript))
            return;
        graph.claimLiteral(moduleResource, L0.SCLScript_definition, definition, Bindings.STRING);
    }

}