/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor2.SCLPartitionScanner;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class SCLScriptEditorDocumentProvider extends AbstractDocumentProvider {

    private SCLSourceViewerConfigurationNew sourceViewer;
    protected AnnotationModel annotationModel = new AnnotationModel();

    private Object currentElement;
    private SCLScriptSource currentSource;

    public SCLScriptEditorDocumentProvider(SCLSourceViewerConfigurationNew sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    private void updateScriptSource(Object input) {
        if (currentElement != null && currentElement.equals(input))
            return;
        currentElement = input;
        if (!(currentElement instanceof SCLScriptEditorInput))
            return;

        SCLScriptSource source = ((SCLScriptEditorInput) currentElement).getAdapter(SCLScriptSource.class);
        if (source != null)
            currentSource = source;
    }

    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        updateScriptSource(element);
        if (currentSource == null)
            throw new CoreException(
                    new Status(Status.ERROR, "org.simantics.scl.ui", "Source for the SCL module could not be found."));
        Document document = new Document(currentSource.getSourceText());
        IDocumentPartitioner partitioner = new FastPartitioner(new SCLPartitionScanner(), SCLPartitionScanner.PARTITION_TYPES);
        partitioner.connect(document);
        document.setDocumentPartitioner(partitioner);
        sourceViewer.updateCompletionAssistModuleName(currentSource.getScriptURI());
        return document;
    }

    @Override
    public void changed(Object element) {
        updateScriptSource(element);
    }

    @Override
    public void aboutToChange(Object element) {
        super.aboutToChange(element);
    }

    @Override
    public boolean isModifiable(Object element) {
        if (currentSource == null)
            return false;
        return currentSource.isUpdateable();
    }

    @Override
    public boolean isReadOnly(Object element) {
        return !isModifiable(element);
    }

    @Override
    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        SCLScriptEditorInput input = (SCLScriptEditorInput) element;
        return new SCLScriptAnnotationModel(input, SCLOsgi.MODULE_REPOSITORY);
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element,
            IDocument document, boolean overwrite) throws CoreException
    {
        if (currentSource != null)
            currentSource.update(document.get());
    }

    @Override
    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

}
