/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.StringUtils;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class ReadSCLScriptDefinition extends UnaryRead<String, String> {

    public ReadSCLScriptDefinition(String scriptURI) {
        super(scriptURI);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        Resource scriptResource = graph.getPossibleResource(parameter);
        if (scriptResource == null)
            return null;
        Layer0 L0 = Layer0.getInstance(graph);
        if (!graph.isInstanceOf(scriptResource, L0.SCLScript))
            return null;
        return StringUtils.safeString( graph.getPossibleRelatedValue(scriptResource, L0.SCLScript_definition, Bindings.STRING) );
    }

}