/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.modeling.preferences.SCLIssuePreferences;

/**
 * @author Tuukka Lehtonen
 * @since 1.51.0
 */
public class SCLIssuePreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	private BooleanFieldEditor fSCLExpressionIssuesEnabledEditor = null;

	public SCLIssuePreferencePage() {
		super(GRID);
	}

	@Override
	protected IPreferenceStore doGetPreferenceStore() {
		return new ScopedPreferenceStore(InstanceScope.INSTANCE, SCLIssuePreferences.P_NODE);
	}

	@Override
	public void init(IWorkbench workbench) {
	}

	@Override
	protected void createFieldEditors() {
		fSCLExpressionIssuesEnabledEditor = new BooleanFieldEditor(
				SCLIssuePreferences.P_SCL_EXPRESSION_ISSUES_ENABLED,
				"&SCL Expression issue validation enabled",
				getFieldEditorParent());
		addField(fSCLExpressionIssuesEnabledEditor);
	}

}