package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Collection;

import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Objects;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.modelBrowser2.model.SheetsNode;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class SheetContributor extends ViewpointContributor<SheetsNode> {

    @Override
    public Collection<?> getContribution(ReadGraph graph, SheetsNode library) throws DatabaseException {

        SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
        Resource configuration = graph.getPossibleObject(library.resource, SimulationResource.getInstance(graph).HasConfiguration);
        return graph.syncRequest(new Objects(configuration, sr.HasSheet));

    }

    @Override
    public String getViewpointId() {
        return "Standard";
    }

}