/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.swt.ImagerContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.modeling.ui.modelBrowser2.model.RelationViewNode;
import org.simantics.operation.Layer0X;
import org.simantics.ui.icons.ImageDescriptorProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;

/**
 * An imager contribution for giving {@link RelationViewNode} instances an image
 * in a {@link GraphExplorer} based on the relation the :RelationView instance
 * applies to.
 * 
 * <p>
 * Given
 * 
 * <pre>
 * _ : RelationView
 *     L0.AppliesRelation R
 * </pre>
 * 
 * it will attempt to adapt <code>R</code> into an
 * {@link ImageDescriptorProvider} and resolve the {@link ImageDescriptor} from
 * there.
 * 
 * @author Tuukka Lehtonen
 */
public class RelationViewImager extends ImagerContributor<RelationViewNode> {

    @Override
    public ImageDescriptor getDescriptor(ReadGraph graph, RelationViewNode input) throws DatabaseException {
        Resource relation = graph.getPossibleObject(input.resource, Layer0X.getInstance(graph).AppliesRelation);
        if (relation == null)
            return null;

        ImageDescriptorProvider provider = graph.getPossibleAdapter(relation, ImageDescriptorProvider.class);
        if (provider == null)
            return null;

        try {
            return provider.get();
        } catch (ProvisionException e) {
            throw new ServiceException(e);
        }
    }

}
