/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;

import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ContextInputCallbackViewpointContributor;
import org.simantics.browsing.ui.graph.tester.GraphTesters;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.modelBrowser2.model.RelationViewNode;
import org.simantics.operation.Layer0X;

public class RelationView extends ContextInputCallbackViewpointContributor {

    public RelationView() {
        super(RelationViewNode.class);
    }

    @Override
    public Tester getNodeContextTester() {
        return GraphTesters.type(Layer0X.URIs.RelationView);
    }

    @Override
    public String getViewpointId() {
        return "Standard";
    }

    @Override
    protected void finalize() throws Throwable {
        //System.out.println("**** FINALIZING RelationView " + this);
        super.finalize();
    }

    @Override
    public void getContribution(ReadGraph graph, final NodeContext context, final Consumer<Collection<?>> callback) throws DatabaseException {

        final Session session = graph.getSession();

        RelationViewNode model = (RelationViewNode)context.getConstant(BuiltinKeys.INPUT);
        final Resource view = model.resource;

        final String filter = context.getConstant(BuiltinKeys.FILTER);
        Layer0 l0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);

        final Resource input = graph.getPossibleObject(view, l0.PartOf);
        final Resource relation = graph.getPossibleObject(view, L0X.AppliesRelation);
        final String bindingPattern = graph.getPossibleRelatedValue(view, L0X.HasBindingPattern, Bindings.STRING);

        final GenericRelationIndex index = graph.syncRequest(new org.simantics.db.common.primitiverequest.Adapter<GenericRelationIndex>(relation, GenericRelationIndex.class));

        // TODO: use DB ExternalRead instead of this listener hack which proliferates the index with listeners.

        index.addListener(session, input, new Runnable() {
            @Override
            public void run() {
                Simantics.async(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            callback.accept(compute(session, filter, bindingPattern, view, relation, input));
                        } catch (DatabaseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });

        callback.accept(compute(graph, filter, bindingPattern, view, relation, input));

    }

    Collection<?> compute(RequestProcessor processor, String filter, String bindingPattern, final Resource view, Resource relation, Resource input) throws DatabaseException {
        if (filter == null)
            filter = "";

        GenericRelationIndex index = processor.syncRequest(new Adapter<GenericRelationIndex>(relation, GenericRelationIndex.class));
        final Collection<Map<String, Object>> results = index.query(processor, filter, bindingPattern, new Object[] { input }, 1000);

        return processor.syncRequest(new Read<Collection<?>>() {
            @Override
            public Collection<?> perform(ReadGraph graph) throws DatabaseException {
                RelationViewContributor contrib = graph.syncRequest(Queries.adapt(view, RelationViewContributor.class));
                return contrib.getContribution(graph, results);
            }
        });
    }

}
