/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Collection;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.modelBrowser2.model.ChartNode;
import org.simantics.structural.ui.modelBrowser.contributions.LibraryViewpointContributor;

/**
 * @author Tuukka Lehtonen
 */
public class ChartPlots extends LibraryViewpointContributor<ChartNode> {

    @Override
    protected Read<Collection<Resource>> getChildRequest(ReadGraph graph, ChartNode chart) throws DatabaseException {
        return new ObjectsWithType(
                chart.resource,
                Layer0.getInstance(graph).ConsistsOf,
                ChartResource.getInstance(graph).Chart_Item);
    }

}
