/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.layer0.Layer0;

@Deprecated
public class Node implements INode, IDropTargetNode {

    protected Resource resource;

    public Node(Resource resource) {
        assert resource != null;
        this.resource = resource;
    }

    public Resource getResource() {
        return resource;
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
        return LabelerUtil.safeStringRepresentation(g, resource);
    }

    @Override
    public ImageDescriptor getImage(ReadGraph graph) throws DatabaseException {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    @Override
    public int getCategory(ReadGraph graph) throws DatabaseException {
        return 0;
    }

    @Override
    public Modifier getModifier(Session session, String columnId) {
        return null;
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChildren(ReadGraph g) throws DatabaseException {
        return !getChildren(g).isEmpty();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Resource.class)
            return resource;
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        return getClass().equals(obj.getClass()) && resource.equals(((Node)obj).resource);
    }

    @Override
    public int hashCode() {
        return getClass().hashCode()*31 + resource.hashCode();
    }

    @Override
    public void handleDrop(Session session, ISelection data) {
    }

    /**
     * For backwards compatibility with the new model browser and browsing framework.
     */
    @Override
    public void drop(Object data) {
        if (data instanceof ISelection) {
            handleDrop(Simantics.getSession(), (ISelection) data);
        }
    }

    @Override
    public void handleDelete(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(graph);
        graph.deny(resource, l0.PartOf);
        RemoverUtil.remove(graph, resource);
    }

}
