/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.common.node.IRefreshable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * INode represents a node in the graph based object model.
 * 
 * @see IDeletable
 * @see IModifiable
 * @see IRefreshable
 * @see IOpenable
 * 
 * @deprecated <a href="https://www.simantics.org/wiki/index.php/Org.simantics.browsing.ui_Manual">See tutorial for new features</a>
 */
@Deprecated
public interface INode extends IAdaptable {
    String getLabel(ReadGraph graph) throws DatabaseException;
    int getCategory(ReadGraph graph) throws DatabaseException;
    Collection<?> getChildren(ReadGraph graph) throws DatabaseException;
    boolean hasChildren(ReadGraph graph) throws DatabaseException;
    ImageDescriptor getImage(ReadGraph graph) throws DatabaseException;
    void handleDrop(Session session, ISelection selection);
    Modifier getModifier(Session session, String columnId);

    /**
     * Delete node in the background system. The node is considered deletable
     * only if it implements {@link IDeletable}.
     */
    void handleDelete(WriteGraph graph) throws DatabaseException;
}
