/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.actions.NewSubscription;
import org.simantics.modeling.ui.modelBrowser2.model.SubscriptionsNode;
import org.simantics.utils.ui.AdaptionUtils;

public class NewSubscriptionHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        SubscriptionsNode node = AdaptionUtils.adaptToSingle(sel, SubscriptionsNode.class);
        if (node == null)
            return null;
        final Resource model = node.resource;

        new NewSubscription().create(model).run();

        return null;
    }

}

