/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - #7116 regression fix
 *     Semantum Oy - gitlab #147 - expose getPossibleId implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.help.HelpContexts;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.slf4j.LoggerFactory;

public class ContextualHelp extends AbstractHandler {

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(ContextualHelp.class);

    private static String getPossibleId(ExecutionEvent event) {
        try {
            ISelection sel = HandlerUtil.getCurrentSelection(event);
            Resource resource = WorkbenchSelectionUtils.getPossibleResource(sel);
            Variable variable = WorkbenchSelectionUtils.getPossibleVariable(sel);
            if (sel.isEmpty() && resource == null && variable == null)
                return null;

            return Simantics.getSession().syncRequest(new UniqueRead<String>() {
                @Override
                public String perform(ReadGraph graph) throws DatabaseException {
                    return HelpContexts.getPossibleId(graph, resource, variable, sel);
                }
            });
        } catch (DatabaseException e) {
            LOGGER.error("", e);
            return null;
        }
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String id = getPossibleId(event);
        if (id != null)
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
        return null;
    }

    /**
     * @deprecated use {@link HelpContexts#getPossibleId(ReadGraph, Resource, Variable, Object)} instead
     */
    @Deprecated
    public static String getPossibleId(ReadGraph graph, Resource resource, Variable variable, ISelection sel) throws DatabaseException {
        return HelpContexts.getPossibleId(graph, resource, variable, sel);
    }

}
