/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.genericfileimport.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.modeling.ui.Activator;

/**
 * A factory for generic file import wizard extension.
 * 
 * @author Antti Villberg
 */
public class WizardExtensionFactory implements IExecutableExtensionFactory, IExecutableExtension {

    public static final String GENERIC_FILE_IMPORT_WIZARD = "genericFileImportWizard"; // $//$NON-NLS-1$
 
    private IConfigurationElement config;

    private String id;

    private String propertyName;

    public WizardExtensionFactory() {
        // do nothing
    }

    private Object configure(Object obj) throws CoreException {
        if (obj instanceof IExecutableExtension) {
            ((IExecutableExtension) obj).setInitializationData(config, propertyName, null);
        }
        return obj;
    }

    @Override
    public Object create() throws CoreException {
        if (GENERIC_FILE_IMPORT_WIZARD.equals(id)) {
            return configure(new GenericFileImportWizard());
        }
        throw new CoreException(new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                0, "Unknown id in data argument for " + getClass(), null)); //$NON-NLS-1$
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {

        if (data instanceof String) {
            id = (String) data;
        } else {
            throw new CoreException(new Status(IStatus.ERROR,
                    Activator.PLUGIN_ID, 0,
                    "Data argument must be a String for " + getClass(), null)); //$NON-NLS-1$
        }
        this.config = config;
        this.propertyName = propertyName;
    }

}
