package org.simantics.modeling.ui.function;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

import org.simantics.Simantics;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.NamedResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.modeling.ui.typicals.NewTypicalDiagramInstance;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.ui.workbench.action.DefaultActions;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class All {

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Variable")
    public static Variable singleVariableSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	return ScenegraphLoaderUtils.getVariableSelection(graph, context);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Resource")
    public static Resource projectSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	return Simantics.getProjectResource();
    }
    
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> StatePersistor")
    public static StatePersistor standardPersistor(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	String configurationId = context.getParent(graph).getPossiblePropertyValue(graph, "browseContext");
    	return new StandardPersistor(configurationId);
    }

    @SCLValue(type = "Resource -> Resource -> Resource")
    public static Resource standardTypicalInstantiator(final Resource model, final Resource target) throws DatabaseException {
        final Session session = Simantics.getSession();

        Collection<Resource> typicals = TypicalUtil.findModelTypicals(session, model);
        if (typicals.isEmpty()) {
            ShowMessage.showInformation("No Typical Diagrams", "There are no typical diagrams in the selected model. Cannot instantiate.");
            return null;
        }
        final Collection<NamedResource> namedTypicals = TypicalUtil.toNamedResources(session, typicals);

        return TypicalUtil.syncExec(procedure ->  {
            NewTypicalDiagramInstance.asyncQueryFromList(namedTypicals, selectedTypical -> {
                try {
                    if (selectedTypical != null) {
                        session.syncRequest(TypicalUtil.instantiateTemplate(target, selectedTypical, instance -> {
                            try {
                                Set<Resource> customlyNamed = new HashSet<Resource>();
                                TypicalUtil.applyTypicalModuleNames(instance.first, instance.second, customlyNamed);
                                //TypicalUtil.generateFreshModuleNames(instance.first, instance.second, customlyNamed);
                                procedure.execute(instance.second);
                                // Perform default action on the newly created diagram
                                DefaultActions.asyncPerformDefaultAction(session, instance.second, false, false, true);
                            } catch (DatabaseException e) {
                                procedure.exception(e);
                            }
                        }));
                    }
                } catch (Throwable e) {
                    procedure.exception(e);
                } finally {
                    procedure.execute(null);
                }
            });
        });
    }

}
