/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

/**
 * @author Tuukka Lehtonen
 */
public class CommandUtil {

    /**
     * @param viewIdPart a part of the ID of the view to be shown
     * @throws ExecutionException any errors occur during command execution or
     *         if several views contain the specified string
     */
    public static void showView(String viewIdPart) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandService = (ICommandService) workbench.getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService) workbench.getService(IHandlerService.class);
        Command showView = commandService.getCommand("org.eclipse.ui.views.showView");

        try {
            IParameter viewIdParm = showView.getParameter("org.eclipse.ui.views.showView.viewId");

            // the viewId parameter provides a list of valid values ... if you
            // knew the id of the problem view, you could skip this step.
            // This method is supposed to be used in places like the keys
            // preference page, to allow the user to select values
            IParameterValues parmValues = viewIdParm.getValues();
            String viewId = null;
            for (Object o : parmValues.getParameterValues().values()) {
                String id = (String) o;
                if (id.indexOf(viewIdPart) != -1) {
                    viewId = id;
                    break;
                }
            }
            if (viewId == null)
                return;

            Parameterization parm = new Parameterization(viewIdParm, viewId);
            ParameterizedCommand parmCommand = new ParameterizedCommand(showView, new Parameterization[] { parm });

            handlerService.executeCommand(parmCommand, null);
        } catch (ParameterValuesException e) {
            throw new ExecutionException("could not get parameter values for showView command", e);
        } catch (NotDefinedException e) {
            throw new ExecutionException("showView command definition problem", e);
        } catch (NotEnabledException e) {
            throw new ExecutionException("showView command not enabled", e);
        } catch (NotHandledException e) {
            throw new ExecutionException("no handler for showView command", e);
        }
    }

}
