/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.dnd;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.modeling.ui.Activator;

/**
 * @author Tuukka Lehtonen
 * @since 1.37.0
 */
class MarkupDialog extends Dialog {

    private String title;
    private String topText;
    private String message;
    private int dialogIconType;
    private int viewerStyle;
    private MarkupViewer viewer;

    private IDialogSettings dialogBoundsSettings;

    protected MarkupDialog(Shell parentShell, String dialogId, String title, String topText, String message, int dialogIconType, int viewerStyle) {
        super(parentShell);
        this.title = title;
        this.topText = topText;
        this.message = message;
        this.dialogIconType = dialogIconType;
        this.viewerStyle = viewerStyle;
        setShellStyle(getShellStyle() | SWT.RESIZE);

        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        dialogBoundsSettings = settings.getSection(dialogId);
        if (dialogBoundsSettings == null)
            dialogBoundsSettings = settings.addNewSection(dialogId);
    }

    @Override
    protected IDialogSettings getDialogBoundsSettings() {
        return dialogBoundsSettings;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(title);
        newShell.setImage(newShell.getDisplay().getSystemImage(dialogIconType));
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite) super.createDialogArea(parent);

        Text text = new Text(composite, SWT.READ_ONLY | SWT.MULTI | SWT.WRAP);
        text.setEditable(false);
        text.setText(topText);
        GridDataFactory.fillDefaults()
        .grab(true, false)
        .hint(convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH), SWT.DEFAULT)
        .applyTo(text);

        viewer = new MarkupViewer(composite, null, viewerStyle);
        viewer.setMarkupLanguage(new MarkdownLanguage());
        viewer.setEditable(false);
        MarkupViewerConfiguration configuration = new MarkupViewerConfiguration(viewer, Activator.getDefault().getPreferenceStore());
        viewer.configure(configuration);
        viewer.setDocument(new Document(message));
        GridDataFactory.fillDefaults()
        .grab(true, true)
        .hint(convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH), SWT.DEFAULT)
        .applyTo(viewer.getControl());

        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        createButton(parent, IDialogConstants.PROCEED_ID, IDialogConstants.PROCEED_LABEL, true);
        createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (IDialogConstants.PROCEED_ID == buttonId) {
            okPressed();
        } else if (IDialogConstants.CANCEL_ID == buttonId) {
            cancelPressed();
        }
    }

    public static int open(Shell parent, String dialogId, String title, String topText, String message, int dialogIconType, int dialogStyle, int sourceViewerStyle) {
        MarkupDialog dialog = new MarkupDialog(parent, dialogId, title, topText, message, dialogIconType, sourceViewerStyle);
        dialogStyle &= SWT.SHEET;
        dialog.setShellStyle(dialog.getShellStyle() | dialogStyle);
        return dialog.open();
    }

}