/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorDataImpl;
import org.simantics.browsing.ui.common.processors.ComparableFactoryResolver;
import org.simantics.browsing.ui.common.processors.ComparableSelectorQueryProcessor;
import org.simantics.browsing.ui.common.processors.ImageDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.ImagerFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelerFactoryResolver;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.UserSelectedViewpointFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.ViewpointFactoryResolver;
import org.simantics.browsing.ui.graph.impl.AsyncReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.InheritsQueryProcessor;
import org.simantics.browsing.ui.graph.impl.ReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.RelatedObjectsQueryProcessor;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultKeyListener;
import org.simantics.browsing.ui.swt.DefaultMouseListener;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.TypesQueryProcessor;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.modelBrowser.ModelEvaluators;
import org.simantics.modeling.ui.modelBrowser.model.INode;
import org.simantics.modeling.ui.modelBrowser.model.INode2;
import org.simantics.structural.ui.menuContributions.LinkWithEditorContribution;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.datastructures.Functions;

/**
 * TODO: change to use newer contribution mechanisms, get rid of
 * {@link ModelEvaluators} use.
 * 
 * @author Tuukka Lehtonen
 */
public class DiagramOutlinePage extends Page implements IContentOutlinePage, IPostSelectionProvider {

    ISessionContextProvider sessionContextProvider;
    IResourceEditorInput2    input;
    LocalResourceManager    resourceManager;
    Composite               composite;
    GraphExplorer           explorer;
    LinkWithEditor          linkWithEditor;

    public DiagramOutlinePage(ISessionContextProvider contextProvider, IResourceEditorInput2 input) {
        assert contextProvider != null;
        assert input != null;

        this.sessionContextProvider = contextProvider;
        this.input = input;
    }

    @Override
    public void createControl(Composite parent) {
        resourceManager = new LocalResourceManager(JFaceResources.getResources());
        composite = new Composite(parent, SWT.NONE);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.explorer = GraphExplorerFactory.getInstance().selectionDataResolver(new DefaultSelectionDataResolver()).create(composite);
		Control control = explorer.getControl();
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        new ContextMenuInitializer("#GraphExplorerPopup").createContextMenu(control, selectionProvider, getSite()); //$NON-NLS-1$
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);

        // Consider ENTER presses to simulate mouse left button double clicks
        Function<String[]> resolver = Functions.constant(ColumnKeys.SINGLE);
        explorer.addListener(new DefaultKeyListener(sessionContextProvider, explorer, resolver));

        // Default double click handling
        explorer.addListener(new DefaultMouseListener(explorer));

        ISessionContext sessionContext = sessionContextProvider.getSessionContext();
        Session session = sessionContext != null ? sessionContext.getSession() : null;
        EvaluatorData data = null;
        if (session != null) {
            data = createEvaluatorData(sessionContext);
            explorer.setDataSource(new AsyncReadGraphDataSource(session));
            explorer.setDataSource(new ReadGraphDataSource(session));
        } else {
            data = new EvaluatorDataImpl();
            explorer.removeDataSource(AsyncReadGraph.class);
            explorer.removeDataSource(ReadGraph.class);
        }

        explorer.setProcessor(new ComparableFactoryResolver(data));
        explorer.setProcessor(new ViewpointFactoryResolver(data));
        explorer.setProcessor(new LabelerFactoryResolver(data));
        explorer.setProcessor(new ImagerFactoryResolver(data));
        explorer.setProcessor(new LabelDecoratorFactoryResolver(data));
        explorer.setProcessor(new ImageDecoratorFactoryResolver(data));
        explorer.setPrimitiveProcessor(new TypesQueryProcessor());
        explorer.setPrimitiveProcessor(new InheritsQueryProcessor());
        explorer.setPrimitiveProcessor(new RelatedObjectsQueryProcessor());

        explorer.setProcessor(new ComparableSelectorQueryProcessor());
        explorer.setPrimitiveProcessor(new UserSelectedViewpointFactoryQueryProcessor());
        explorer.setPrimitiveProcessor(new UserSelectedComparableFactoryQueryProcessor());

        try {

            // Look for a proper input resource to give to the model browser.
            final Resource diagram = input.getResource();
            if (diagram != null && session != null) {
                Object finalInput = session.syncRequest(new Read<Resource>() {
                    @Override
                    public Resource perform(ReadGraph graph) throws DatabaseException {
                        ModelingResources mr = ModelingResources.getInstance(graph);
                        return graph.getPossibleObject(diagram, mr.DiagramToComposite);
                    }
                });
                if (finalInput != null)
                    explorer.setRoot(finalInput);
            }

        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }

//        linkWithEditor = new LinkWithEditor();
//        getSite().getActionBars().getToolBarManager().add(linkWithEditor);
    }

    @Override
    public void dispose() {
        if (resourceManager != null) {
            resourceManager.dispose();
            resourceManager = null;
        }
        super.dispose();
    }

    protected EvaluatorData createEvaluatorData(ISessionContext sessionContext) {
        EvaluatorData data = new EvaluatorDataImpl();
        data.addEvaluator(Resource.class, ModelEvaluators.createResourceEvaluator());
        data.addEvaluator(INode.class, ModelEvaluators.createNodeEvaluator());
        data.addEvaluator(INode2.class, ModelEvaluators.createNode2Evaluator());
        return data;
    }

    @Override
    public Control getControl() {
        return composite;
    }

    @Override
    public void setFocus() {
        explorer.setFocus();
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.addSelectionChangedListener(listener);
    }

    @Override
    public ISelection getSelection() {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        return selectionProvider.getSelection();
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.removeSelectionChangedListener(listener);
    }

    @Override
    public void setSelection(ISelection selection) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.setSelection(selection);
    }

    @Override
    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.addPostSelectionChangedListener(listener);
    }

    @Override
    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.removePostSelectionChangedListener(listener);
    }

    static class LinkWithEditor extends LinkWithEditorContribution {
        public LinkWithEditor() {
            super("DiagramOutlinePage.linkWithEditor", Activator.getDefault().getPreferenceStore()); //$NON-NLS-1$
        }
    }

}
