package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;

public class RealizedColorAdapter extends SimpleContextualAdapter<Color, RelationContext> {

	@Override
	public Color adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
		
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource color = context.getStatement().getObject();
		
		double[] rgb = graph.getRelatedValue(color, DIA.RealizedColor_HasRGB, Bindings.DOUBLE_ARRAY); 
		
		return new RGB(rgb[0], rgb[1], rgb[2]);
		
	}

}
