/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class MonitorVariableValueRequest extends BinaryRead<Resource, Resource, MonitorVariableValue> {

    public MonitorVariableValueRequest(Resource runtimeDiagram, Resource monitorElement) {
        super(runtimeDiagram, monitorElement);
    }

    @Override
    public MonitorVariableValue perform(ReadGraph graph) throws DatabaseException {
        MonitorVariable monitorVariable = graph.syncRequest(new ResolveMonitorVariable(parameter, parameter2));
        if (monitorVariable == null)
            return null;
        String value = graph.syncRequest(new MonitorValue(monitorVariable.getExpression(), monitorVariable.getFormat(),
                monitorVariable.getVariable()));
        return new MonitorVariableValue(monitorVariable, value);
    }

}