package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.browsing.ui.swt.widgets.impl.ModifyComboListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.ui.fonts.FontDescriptor;

public class FontSizeModifier extends ModifyComboListenerImpl<Resource, Integer> {

	@Override
	public void applySelection(WriteGraph graph, Resource monitor, Integer newSize) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		FontDescriptor fd = graph.getPossibleRelatedAdapter(monitor, DIA.HasFont, FontDescriptor.class);
		if (fd != null) {
			graph.markUndoPoint();
			Resource font = graph.newResource();
			graph.claim(font, L0.InstanceOf, null, DIA.RealizedFont);
			graph.addLiteral(font, DIA.RealizedFont_HasFamily, DIA.RealizedFont_HasFamily_Inverse, L0.String, fd.getFamily(), Bindings.STRING);
			graph.addLiteral(font, DIA.RealizedFont_HasStyle, DIA.RealizedFont_HasStyle_Inverse, L0.Integer, fd.getStyle(), Bindings.INTEGER);
			graph.addLiteral(font, DIA.RealizedFont_HasSize, DIA.RealizedFont_HasSize_Inverse, L0.Integer, newSize, Bindings.INTEGER);
			graph.deny(monitor, DIA.HasFont);
			graph.claim(monitor, DIA.HasFont, font);
		}
	}

}