package org.simantics.modeling.ui.diagram.monitor;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.StringUtils;

/**
 * @author Tuukka Lehtonen
 */
public class AvailableTemplateFactory extends ReadFactoryImpl<Resource, Map<String, Object>> {

    @Override
    public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        Instances query = graph.adapt(DIA.MonitorTemplate, Instances.class);
        Resource model = graph.syncRequest(new PossibleModel(input));
        if (model == null)
            return Collections.emptyMap();
        Map<String, Object> result = new TreeMap<>(AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        for (Resource template : query.find(graph, model)) {
            String label = graph.getPossibleRelatedAdapter(template, L0.HasLabel, String.class);
            result.put(StringUtils.safeString(label), template);
        }
        return result;

    }

}
