package org.simantics.modeling.ui.diagram;

import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.Commands;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ResetProfileMonitorTransformContribution extends DynamicMenuContribution implements IExecutableExtension {

    String          name    = ""; //$NON-NLS-1$
    ImageDescriptor image   = null;

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
            throws CoreException {
        if (data instanceof Map<?,?>) {
            @SuppressWarnings("unchecked")
            Map<String, String> args = (Map<String, String>) data;
            name = args.get("name"); //$NON-NLS-1$
            String imageId = args.get("image"); //$NON-NLS-1$
            image = Activator.getDefault().getImageRegistry().getDescriptor(imageId);
        }
    }

    @Override
    protected Object[] getSelectedObjects() {
        return ResourceAdaptionUtils.toResources(getSelection());
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, final Object[] elements) throws DatabaseException {
        if (elements.length == 0)
            return NONE;

        boolean todo = false;
        DiagramResource DIA = DiagramResource.getInstance(graph);
        for (Object object : elements) {
            Resource element = (Resource)object;
            Statement stm = graph.getPossibleStatement(element, DIA.Element_profileMonitorOffset);
            if (stm != null && !stm.isAsserted(element)) {
                todo = true;
                break;
            }
        }

        if (!todo)
            return NONE;

        return new IContributionItem[] {
                new ActionContributionItem(new Action(name, image) {
                    @Override
                    public void run() {
                        Simantics.async(new WriteRequest() {
                            @Override
                            public void perform(WriteGraph graph) throws DatabaseException {
                                Command cmd = Commands.get(graph, "Simantics/Profile/resetProfileMonitorPosition"); //$NON-NLS-1$
                                Resource model = graph.syncRequest(new IndexRoot((Resource)elements[0]));
                                for(Object element : elements)
                                    cmd.execute(graph, model, element);
                            }
                        });
                    }
                })
        };
    }

}
