/*******************************************************************************
 * Copyright (c) 2013, 2015 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - adaption to SCLModuleEditor/TextEditor
 *******************************************************************************/
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;

/**
 * @author Antti Villberg
 */
public class SymbolDropHandlerEditor extends SCLModuleEditor {

    public SymbolDropHandlerEditor() {
        super();
    }

    @Override
    protected void preInitialize() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew(resourceManager);
        setDocumentProvider(new SymbolDropHandlerDocumentProvider(sourceViewerConfiguration, display, this));
        setSourceViewerConfiguration(sourceViewerConfiguration);
        
    }

}