/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Composite;
import org.simantics.ui.workbench.ResourceEditorPart;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen (IExecutableExtension)
 */
public class ComponentTypeEditor extends ResourceEditorPart implements IExecutableExtension {

    protected ComponentTypeViewer viewer;
    protected String formTitle = Messages.ComponentTypeEditor_UserComponentInterface;

    @Override
    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        if (data instanceof String) {
            String[] params = ((String) data).split(";"); //$NON-NLS-1$
            for (String param : params) {
                String[] keyValue = param.split("="); //$NON-NLS-1$
                if (keyValue.length == 2) {
                    if ("formTitle".equals(keyValue[0])) { //$NON-NLS-1$
                        formTitle = keyValue[1];
                    }
                }
            }
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        viewer = new ComponentTypeViewer(parent, getInputResource(), getEditorTitle());
        activateValidation();
    }

    protected String getEditorTitle() {
        return formTitle;
    }

    @Override
    public void setFocus() {
        viewer.setFocus();
    }

}
