/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.osgi.util.NLS;
import org.simantics.utils.format.TimeFormat;

/**
 * @author Toni Kalajainen
 */
public class TimeInputValidator implements IInputValidator {
	
	Format decimalFormat = new DecimalFormat("0"); //$NON-NLS-1$

	Format timeFormat = new TimeFormat(100, 0);
	
	double minValue;
	
	public TimeInputValidator(double minValue) {
		this.minValue = minValue;
	}	
	
	public Double parse(String text) {
		if (text==null) return null;
		text = text.trim();
		if (text.equals("")) return null; //$NON-NLS-1$

		try {
			return (Double) timeFormat.parseObject(text);
		} catch (ParseException e) {
		}

		try {
			Number n = (Number) decimalFormat.parseObject(text);
			if (n instanceof Double) return (Double) n;
			return n.doubleValue();
		} catch (ParseException e) {
		}
		
		return null;
	}

	@Override
	public String isValid(String text) {
		if (text == null)
			return "Null"; //$NON-NLS-1$
		text = text.trim();
		if (text.equals("")) //$NON-NLS-1$
			return null;

		try {
			Double d = (Double) timeFormat.parseObject(text);

			if (d != null && d.doubleValue() < minValue)
				return NLS.bind(Messages.TimeInputValidator_ValueRange, minValue);
			return null;
		} catch (ParseException e) {
		}

		try {
			Number n = (Number) decimalFormat.parseObject(text);
			if (n != null && n.doubleValue() < minValue)
				return NLS.bind(Messages.TimeInputValidator_ValueRange, minValue); 
			return null;
		} catch (ParseException e) {
			return "Unable to parse specified value as a measure of time."; //$NON-NLS-1$
		}
	}
	
}
