/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import java.util.ArrayList;
import java.util.Collections;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.property.OrderedResource;
import org.simantics.operation.Layer0X;

/**
 * @author Tuukka Lehtonen
 */
public class ObtainedDoubleAdapter extends SimpleContextualAdapter<Double, RelationContext> {

    @Override
    public Double adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance(graph);
        ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
        for (Statement stm : graph.getStatements(context.getSubject(), L0X.ObtainsProperty)) {
            Integer position = graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation,
                    Bindings.INTEGER);
            order.add(new OrderedResource(position, stm.getObject()));
        }
        if (order.size() > 1)
            Collections.sort(order);
        for (OrderedResource or : order) {
            Double result = graph.getPossibleRelatedAdapter(or.r, context.getStatement().getPredicate(), Double.class);
            if (result != null)
                return result;
        }

        throw new AdaptionException("No obtained double available");
    }

}
